﻿Option Explicit On
Option Infer On
Option Strict On

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Tworzenie danych.
        Dim x_all As XElement = _
            <AllCustomers>
                <PositiveBalances>
                    <Customer FirstName="Dan" LastName="Dump">117.95</Customer>
                    <Customer FirstName="Ann" LastName="Archer">100.00</Customer>
                    <Customer FirstName="Carly" LastName="Cant">62.40</Customer>
                </PositiveBalances>
                <NegativeBalances>
                    <Customer FirstName="Ben" LastName="Best">-24.54</Customer>
                    <Customer FirstName="Frank" LastName="Fix">-150.90</Customer>
                    <Customer FirstName="Edna" LastName="Ever">-192.75</Customer>
                </NegativeBalances>
            </AllCustomers>

        Dim ben As XElement = x_all.Element("NegativeBalances").Element("Customer")
        Dim edna As XElement = x_all.<NegativeBalances>.<Customer>(2)
        Dim edna2 As XElement = x_all.Element("NegativeBalances").Descendants("Customer")(2)

        Dim txt As String = ""

        txt &= "*** ben.Ancestors()" & vbCrLf
        Dim ances = ben.Ancestors()
        'Dim ances = ben.Ancestors("AllCustomers")
        For Each o In ances
            txt &= "Przodek: <" & o.Name.ToString() & ">..." & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** ben.AncestorsAndSelf()" & vbCrLf
        Dim ansces_self = ben.AncestorsAndSelf()
        'Dim ansces_self = ben.AncestorsAndSelf("Customer")
        For Each o In ansces_self
            txt &= "Przodek/Self: <" & o.Name.ToString() & ">..." & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** ben.Attributes()" & vbCrLf
        Dim attr = ben.Attributes()
        'Dim elem = x_all.Elements("NegativeBalances")
        For Each o In attr
            txt &= "Atrybut: " & o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** x_all.Descendants(""Customer"")" & vbCrLf
        'Dim desc = x_all.Descendants()
        Dim desc = x_all.Descendants("Customer")
        For Each o In desc
            txt &= "Potomek: " & o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** x_all.DescendantNodes()" & vbCrLf
        Dim desc_nodes = x_all.DescendantNodes()
        For Each o In desc_nodes
            txt &= "Węzeł potomka: " & TypeName(o) & vbCrLf ' o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** x_all.descendantsAndSelf()" & vbCrLf
        Dim desc_self = x_all.DescendantsAndSelf()
        'Dim desc_self = x_all.descendantsAndSelf("Customer")
        For Each o In desc_self
            txt &= "Przodek/Self: <" & o.Name.ToString() & ">..." & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** x_all.Elements()" & vbCrLf
        Dim elem = x_all.Elements()
        'Dim elem = x_all.Elements("NegativeBalances")
        For Each o In elem
            txt &= "Element: <" & o.Name.ToString() & ">..." & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "ben = x_all.Element(""NegativeBalances"").Element(""Customer"")" & _
            vbCrLf & vbTab & ben.ToString() & vbCrLf
        txt &= "*** CStr(ben): " & vbTab & CStr(ben) & vbCrLf
        txt &= "*** CDec(ben): " & vbTab & CDec(ben) & vbCrLf
        txt &= "ben.Attribute(""LastName""): " & ben.Attribute("LastName").Value & vbCrLf
        txt &= vbCrLf

        txt &= "*** ben.ElementsAfterSelf()" & vbCrLf
        Dim after_ben = ben.ElementsAfterSelf()
        For Each o In after_ben
            txt &= "Po Benie: " & o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** edna.ElementsBeforeSelf()" & vbCrLf
        Dim before_edna = edna.ElementsBeforeSelf()
        For Each o In before_edna
            txt &= "Przed Edną: " & o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf

        txt &= "*** x_all.Nodes()" & vbCrLf
        Dim x_nodes = x_all.Nodes()
        For Each o In x_nodes
            If TypeOf o Is XElement Then
                Dim xele As XElement = DirectCast(o, XElement)
                txt &= "Węzeł: <" & xele.Name.ToString() & ">..." & vbCrLf
            Else
                txt &= "Węzeł: " & TypeName(o) & vbCrLf
            End If
        Next o
        txt &= vbCrLf

        txt &= "*** ben.NodesAfterSelf()" & vbCrLf
        Dim ben_nodesafter = ben.NodesAfterSelf()
        For Each o In ben_nodesafter
            txt &= "Węzeł za Benem: " & o.ToString() & vbCrLf
        Next o
        txt &= vbCrLf


        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub
End Class

Public Class Customer
    Public FirstName As String
    Public LastName As String
    Public Balance As Decimal
    Public Overrides Function ToString() As String
        Return FirstName & " " & LastName & " (" & Balance & ")"
    End Function
End Class
