﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        ' Utworzenie DataTable.
        Dim contacts_table As New DataTable("Contacts")

        ' Dodanie kolumn.
        contacts_table.Columns.Add("FirstName", GetType(String))
        contacts_table.Columns.Add("LastName", GetType(String))
        contacts_table.Columns.Add("Street", GetType(String))
        contacts_table.Columns.Add("City", GetType(String))
        contacts_table.Columns.Add("State", GetType(String))
        contacts_table.Columns.Add("Zip", GetType(String))

        ' Pary FirstName-LastName muszą być unikatowe.
        Dim first_last_columns() As DataColumn = { _
            contacts_table.Columns("FirstName"), _
            contacts_table.Columns("LastName") _
        }
        contacts_table.Constraints.Add( _
            New UniqueConstraint(first_last_columns))

        ' Dane kontaktowe.
        contacts_table.Rows.Add(New Object() {"Art", "Ant", _
            "1234 Ash Pl", "Bugville", "CO", "11111"})
        contacts_table.Rows.Add(New Object() {"Bev", "Bug", _
            "22 Beach St", "Bugville", "CO", "22222"})
        contacts_table.Rows.Add(New Object() {"Cid", "Cat", _
            "3 Road Place Lane", "Programmeria", "KS", "33333"})
        contacts_table.Rows.Add(New Object() {"Deb", "Dove", _
            "414 Debugger Way", "Programmeria", "KS", "44444"})
        contacts_table.Rows.Add(New Object() {"Ed", "Eager", _
            "5746 Elm Blvd", "Bugville", "CO", "55555"})
        contacts_table.Rows.Add(New Object() {"Fran", "Fix", _
            "647 Foxglove Ct", "Bugville", "CO", "66666"})
        contacts_table.Rows.Add(New Object() {"Gus", "Gantry", _
            "71762-B Gooseberry Ave", "Programmeria", "KS", "77777"})
        contacts_table.Rows.Add(New Object() {"Hil", "Harris", _
            "828 Hurryup St", "Programmeria", "KS", "88888"})

        ' Attach grdAll to the DataTable.
        grdAll.DataSource = contacts_table
        grdAll.CaptionText = "All Records"

        ' Utworzenie DataView dla State = CO.
        Dim dv_co As New DataView(contacts_table)
        dv_co.RowFilter = "State = 'CO'"
        grdCO.DataSource = dv_co
        grdCO.CaptionText = "CO Records"

        ' Utworzenie DataView dla FirstName >= E.
        Dim dv_name As New DataView(contacts_table)
        dv_name.RowFilter = "FirstName >= 'E'"
        grdName.DataSource = dv_name
        grdName.CaptionText = "LastName >= E"

        ' Znalezienie Hil Harris.
        'dv_name.Sort = "FirstName, LastName"
        'MessageBox.Show("In the last DataGrid, Hil Harris is in row " & _
        '    dv_name.Find(New String() {"Hil", "Harris"}).ToString, _
        '    "Hil Harris", MessageBoxButtons.OK, MessageBoxIcon.Information)
    End Sub
End Class
