﻿Imports System.Data.OleDb

Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        txtDatabase.Text = Application.StartupPath & "\people.mdb"
    End Sub

    Private Sub btnAdd_Click() Handles btnAdd.Click
        ' Utworzenie łańcucha połączenia.
        Dim connect_string As String = _
            "Provider=Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=""" & txtDatabase.Text & """;" & _
            "Persist Security Info=False"

        ' Otwarcie połączenia z bazą danych.
        Dim conn_people As New OleDb.OleDbConnection(connect_string)
        conn_people.Open()

        ' Utworzenie polecenia do wstawiania danych.
        Dim cmd As New OleDbCommand( _
            "INSERT INTO PeopleNames (FirstName, LastName) " & _
            "VALUES (?, ?)", _
            conn_people)

        ' Utworzenie parametrów dla polecenia.
        cmd.Parameters.Add(New OleDbParameter("FirstName", txtFirstName.Text))
        cmd.Parameters.Add(New OleDbParameter("LastName", txtLastName.Text))

        ' Wykonanie polecenia.
        Try
            cmd.ExecuteNonQuery()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

        ' Pokazanie bieżących wartości.
        ShowValues(conn_people)

        ' Zamknięcie połączenia.
        conn_people.Close()
        conn_people.Dispose()
    End Sub

    ' Wyświetlenie wartości w tabeli.
    Private Sub ShowValues(ByVal conn_people As OleDbConnection)
        Dim data_adapter As New OleDbDataAdapter( _
            "SELECT FirstName, LastName " & _
                "FROM PeopleNames " & _
                "ORDER BY FirstName, LastName", _
            conn_people)
        Dim data_table As New DataTable()
        data_adapter.Fill(data_table)

        lstPeople.Items.Clear()
        For Each data_row As DataRow In data_table.Rows
            lstPeople.Items.Add( _
                data_row.Item("FirstName").ToString & " " & _
                data_row.Item("LastName").ToString)
        Next data_row

        data_table.Dispose()
        data_adapter.Dispose()
    End Sub

    ' Wyświetlenie wartości.
    Private Sub btnShowValues_Click() Handles btnShowValues.Click
        ' Utworzenie łańcucha połączenia.
        Dim connect_string As String = _
            "Provider=Microsoft.Jet.OLEDB.4.0;" & _
            "Data Source=""" & txtDatabase.Text & """;" & _
            "Persist Security Info=False"

        ' Otwarcie połączenia z bazą danych.
        Dim conn_people As New OleDb.OleDbConnection(connect_string)
        conn_people.Open()

        ' Pokazanie bieżących wartości.
        ShowValues(conn_people)

        ' Zamknięcie połączenia.
        conn_people.Close()
        conn_people.Dispose()
    End Sub
End Class
