﻿Public Class Form1
    Private Sub Form1_Load() Handles MyBase.Load
        Dim txt As String = ""

        Dim m_employees As New Collection
        m_employees.Add(New Employee("Rod", "Stephens", "Author"))
        m_employees.Add(New Employee("Oingo", "Boingo", "Band"))
        m_employees.Add(New Employee("Sergio", "Aragones", "Artist"))
        Dim emp As Employee

        ' For Each.
        txt &= "For Each:" & vbCrLf
        For Each emp In m_employees
            If emp.FirstName = "Oingo" Then Continue For
            txt &= emp.ToString & vbCrLf
        Next emp
        txt &= vbCrLf

        ' Enumerator.
        txt &= "Enumerator:" & vbCrLf
        Dim employee_enumerator As IEnumerator = m_employees.GetEnumerator()
        Do While (employee_enumerator.MoveNext)
            emp = CType(employee_enumerator.Current, Employee)
            If emp.FirstName = "Oingo" Then Continue Do
            txt &= emp.ToString & vbCrLf
        Loop
        txt &= vbCrLf

        ' Enumerator z While End.
        txt &= "Enumerator z While End:" & vbCrLf
        employee_enumerator.Reset()
        While (employee_enumerator.MoveNext)
            emp = CType(employee_enumerator.Current, Employee)
            If emp.FirstName = "Oingo" Then Continue While
            txt &= emp.ToString & vbCrLf
        End While

        txtResults.Text = txt
        txtResults.Select(0, 0)
    End Sub

    Public Class Employee
        Public FirstName As String
        Public LastName As String
        Public Title As String
        Public Sub New(ByVal first_name As String, ByVal last_name As String, ByVal new_title As String)
            FirstName = first_name
            LastName = last_name
            Title = new_title
        End Sub
        Public Overrides Function ToString() As String
            Return FirstName & " " & LastName
        End Function
    End Class
End Class
