﻿Partial Public Class WizardPage2
    Inherits PageFunction(Of WizardData)

    Private m_WizardData As WizardData
    Private WithEvents m_Page3 As WizardPage3

    ' Zapisanie obiektu WizardData.
    Public Sub New(ByVal wizard_data As WizardData)
        InitializeComponent()

        m_WizardData = wizard_data
    End Sub

    ' Zwrócenie wartości kolejnej strony.
    Private Sub m_Page3_Return(ByVal sender As Object, ByVal e As System.Windows.Navigation.ReturnEventArgs(Of WizardData)) Handles m_Page3.Return
        OnReturn(e)
    End Sub

#Region "Navigation"
    ' Otwarcie kolejnej strony..
    Public Sub btnNext_Click() Handles btnNext.Click
        If NavigationService.CanGoForward Then
            NavigationService.GoForward()
        Else
            m_Page3 = New WizardPage3(m_WizardData)
            NavigationService.Navigate(m_Page3)
        End If
    End Sub

    ' Zwrócenie wyniku oznaczającego wciśnięcie przycisku anulowania.
    Private Sub btnCancel_Click() Handles btnCancel.Click
        m_WizardData.Canceled = True
        OnReturn(New ReturnEventArgs(Of WizardData)(m_WizardData))
    End Sub

    ' Powrót do poprzedniej strony.
    Private Sub btnPrev_Click() Handles btnPrev.Click
        NavigationService.GoBack()
    End Sub
#End Region ' Nawigacja

#Region "Zapisywanie wyborów użytkownika"
    ' Zapisanie wyboru użytkownika.
    Private Sub cboEntree_SelectionChanged() Handles cboEntree.SelectionChanged
        ' Własność Text listy rozwijanej jeszcze nie została zaktualizowana..
        If cboEntree.SelectedIndex < 0 Then
            m_WizardData.Entree = ""
        Else
            m_WizardData.Entree = cboEntree.Items(cboEntree.SelectedIndex).Content
        End If

        ' Włączenie przycisku Next, jeśli użytkownik dokonał wyboru.
        btnNext.IsEnabled = cboEntree.SelectedIndex >= 0
    End Sub

    ' Zapisanie wyboru użytkownika.
    Private Sub cboDrink_SelectionChanged() Handles cboDrink.SelectionChanged
        If cboDrink.SelectedIndex < 0 Then
            m_WizardData.Drink = ""
        Else
            m_WizardData.Drink = cboDrink.Items(cboDrink.SelectedIndex).Content
        End If
    End Sub
#End Region ' Zapisywanie wyborów użytkownika

End Class
