﻿Imports System.Windows.Media.Animation

Class Window1
    Private WithEvents btnCenter As Button
    Private Const BIG_SCALE As Double = 1.5

    Private Sub Window1_Loaded() Handles Me.Loaded
        ' Make a style for the buttons.
        Dim br_button As New RadialGradientBrush( _
            Colors.HotPink, Colors.Red)
        br_button.Center = New Point(0.5, 0.5)
        br_button.RadiusX = 1
        br_button.RadiusY = 1

        Dim style_button As New Style(GetType(Button))
        style_button.Setters.Add(New Setter(Control.BackgroundProperty, br_button))
        style_button.Setters.Add(New Setter(Control.WidthProperty, CDbl(70)))
        style_button.Setters.Add(New Setter(Control.HeightProperty, CDbl(40)))
        style_button.Setters.Add(New Setter(Control.MarginProperty, New Thickness(5)))

        ' Set the transform origin to (0.5, 0.5).
        style_button.Setters.Add(New Setter(Control.RenderTransformOriginProperty, New Point(0.5, 0.5)))

        ' Make a StackPanel to hold the buttons.
        Dim stack_panel As New StackPanel()
        stack_panel.Margin = New Thickness(20)

        ' Add the Left button.
        Dim btn_left As Button
        btn_left = New Button()
        btn_left.Style = style_button
        btn_left.Content = "Left"
        btn_left.RenderTransform = New ScaleTransform(1, 1)
        btn_left.SetValue( _
            StackPanel.HorizontalAlignmentProperty, _
            Windows.HorizontalAlignment.Left)
        AddHandler btn_left.MouseEnter, AddressOf btn_MouseEnter
        AddHandler btn_left.MouseLeave, AddressOf btn_MouseLeave
        stack_panel.Children.Add(btn_left)

        ' Make the Center button.
        btnCenter = New Button()
        btnCenter.Style = style_button
        btnCenter.Content = "Center"
        btnCenter.RenderTransform = New ScaleTransform(1, 1)
        btnCenter.SetValue( _
            StackPanel.HorizontalAlignmentProperty, _
            Windows.HorizontalAlignment.Center)
        AddHandler btnCenter.MouseEnter, AddressOf btn_MouseEnter
        AddHandler btnCenter.MouseLeave, AddressOf btn_MouseLeave
        stack_panel.Children.Add(btnCenter)

        ' Make the Right button.
        Dim btn_right As New Button
        btn_right.Style = style_button
        btn_right.Content = "Right"
        btn_right.RenderTransform = New ScaleTransform(1, 1)
        btn_right.SetValue( _
            StackPanel.HorizontalAlignmentProperty, _
            Windows.HorizontalAlignment.Right)
        AddHandler btn_right.MouseEnter, AddressOf btn_MouseEnter
        AddHandler btn_right.MouseLeave, AddressOf btn_MouseLeave
        stack_panel.Children.Add(btn_right)

        Me.Content = stack_panel
    End Sub

    ' Beep.
    Private Sub btnClickMe_Click() Handles btnCenter.Click
        Beep()
    End Sub

    ' The mouse moved over the button.
    ' Make it larger.
    Private Sub btn_MouseEnter(ByVal btn As Button, ByVal e As System.Windows.Input.MouseEventArgs)
        ' Get the button's transformation.
        Dim scale_transform As ScaleTransform = _
            DirectCast(btn.RenderTransform, ScaleTransform)

        ' Create a DoubleAnimation.
        Dim ani As New DoubleAnimation(1, BIG_SCALE, _
            New Duration(TimeSpan.FromSeconds(0.15)))

        ' Create a clock for the animation.
        Dim ani_clock As AnimationClock = ani.CreateClock()

        ' Associate the clock with the transform's
        ' ScaleX and ScaleY properties.
        scale_transform.ApplyAnimationClock( _
            ScaleTransform.ScaleXProperty, ani_clock)
        scale_transform.ApplyAnimationClock( _
            ScaleTransform.ScaleYProperty, ani_clock)
    End Sub

    ' The mouse moved off of the button.
    ' Make it smaller.
    Private Sub btn_MouseLeave(ByVal btn As Button, ByVal e As System.Windows.Input.MouseEventArgs)
        ' Get the button's transformation.
        Dim scale_transform As ScaleTransform = _
            DirectCast(btn.RenderTransform, ScaleTransform)

        ' Create a DoubleAnimation.
        Dim ani As New DoubleAnimation(BIG_SCALE, 1, _
            New Duration(TimeSpan.FromSeconds(0.15)))

        ' Create a clock for the animation.
        Dim ani_clock As AnimationClock = ani.CreateClock()

        ' Associate the clock with the transform's
        ' ScaleX and ScaleY properties.
        scale_transform.ApplyAnimationClock( _
            ScaleTransform.ScaleXProperty, ani_clock)
        scale_transform.ApplyAnimationClock( _
            ScaleTransform.ScaleYProperty, ani_clock)
    End Sub
End Class
