Imports System.Collections.Generic
Module Module1

   Sub Main()
      Dim empQueue As New Queue(Of Employee)
      Dim intQueue As New Queue(Of Integer)

      Dim r As New Random()

      For counter As Integer = 0 To 8
         empQueue.Enqueue(New Employee(r.Next(10) + 100))
         intQueue.Enqueue(r.Next(10))
      Next

      '' Wywietlenie kolejek
      Console.Write("intQueue: ")
      PrintValues(intQueue)
      Console.WriteLine()
      Console.Write("empQueue: ")
      PrintValues(empQueue)
      Console.WriteLine()

      '' Usunicie po jednym elemencie z kolejek
      Console.WriteLine(vbCrLf + "intQueue.Dequeue {0}" + vbTab, intQueue.Dequeue())
      Console.WriteLine("empQueue.Dequeue {0}" + vbTab, empQueue.Dequeue())


      '' Wywietlenie kolejek
      Console.Write("intQueue: ")
      PrintValues(intQueue)
      Console.WriteLine()
      Console.Write("empQueue: ")
      PrintValues(empQueue)
      Console.WriteLine()

      '' Usunicie kolejnych elementw z kolejek
      Console.WriteLine(vbCrLf + "intQueue.Dequeue {0}" + vbTab, intQueue.Dequeue())
      Console.WriteLine("empQueue.Dequeue {0}" + vbTab, empQueue.Dequeue())

      '' Wywietlenie kolejek
      Console.Write("intQueue: ")
      PrintValues(intQueue)
      Console.WriteLine()
      Console.Write("empQueue: ")
      PrintValues(empQueue)
      Console.WriteLine()

      '' Odczytanie pierwszego elementu spord pozostaych w kolejce
      Console.WriteLine(vbCrLf + "intQueue.Peek {0}" + vbTab, intQueue.Peek())
      Console.WriteLine("empQueue.Peek {0}" + vbTab, empQueue.Peek())

      '' Wywietlenie kolejek
      Console.Write("intQueue: ")
      PrintValues(intQueue)
      Console.WriteLine()
      Console.Write("empQueue: ")
      PrintValues(empQueue)
      Console.WriteLine()



   End Sub
   Public Sub PrintValues(ByVal myCollection As IEnumerable(Of Integer))
      Dim myEnumerator As IEnumerator(Of Integer) = _
      myCollection.GetEnumerator()
      While myEnumerator.MoveNext()
         Console.Write("{0} ", myEnumerator.Current)
      End While
   End Sub

   Public Sub PrintValues(ByVal myCollection As IEnumerable(Of Employee))
      Dim myEnumerator As IEnumerator(Of Employee) = _
      myCollection.GetEnumerator()
      While myEnumerator.MoveNext()
         Console.Write("{0} ", myEnumerator.Current)
      End While
   End Sub



End Module
Public Class Employee
   Implements IComparable(Of Employee)

   Private employeeID As Integer

   Public Sub New(ByVal theID As Integer)
      Me.employeeID = theID
   End Sub
   Public Overrides Function ToString() As String
      Return employeeID.ToString()
   End Function
   Public Property EmpID() As Integer
      Get
         Return employeeID
      End Get
      Set(ByVal value As Integer)
         employeeID = value
      End Set
   End Property

   Function CompareTo(ByVal rhs As Employee) As Integer _
   Implements IComparable(Of WorkingWithQueues.Employee).CompareTo
      Return Me.employeeID.CompareTo(rhs.employeeID)
   End Function

End Class
