Imports System.Drawing
Public Class ClockFaceCtrl
   Private Const FaceRadius As Integer = 700
   Private b24Hours As Boolean = False
   Private currentTime As DateTime
   Private Shared DateRadius As Integer = 900
   Private Shared offset As Integer = 0
   Private sdToday As StringDraw
   Private xCenter As Integer = 0
   Private yCenter As Integer = 0
   Private isMoving As Boolean = False
   Private currentColor As Color

   Private myFont As Font = New Font("Verdana", 80)
   Private myFontFamily As String = "Verdana"
   Private myFontSize As Single = 80
   Private isBold As Boolean = False
   Private isItalic As Boolean = False

   Public Property FontFamily() As String
      Get
         Return myFontFamily
      End Get
      Set(ByVal value As String)
         myFontFamily = value
      End Set
   End Property
   Public Property FontSize() As Single
      Get
         Return myFontSize
      End Get
      Set(ByVal value As Single)
         myFontSize = value
      End Set
   End Property
   Public WriteOnly Property Bold() As Boolean
      Set(ByVal value As Boolean)
         isBold = value
      End Set
   End Property
   Public WriteOnly Property Italic() As Boolean
      Set(ByVal value As Boolean)
         isItalic = value
      End Set
   End Property

   Private Class LtrDraw
      Private myChar As Char
      Private _x As Single
      Private _y As Single
      Private oldx As Single
      Private oldy As Single


      Public Sub New(ByVal c As Char)
         myChar = c
      End Sub 'New

      Public Property X() As Single
         Get
            Return _x
         End Get
         Set(ByVal Value As Single)
            oldx = _x
            _x = Value
         End Set
      End Property

      Public Property Y() As Single
         Get
            Return _y
         End Get
         Set(ByVal Value As Single)
            oldy = _y
            _y = Value
         End Set
      End Property

      Public Function GetWidth( _
        ByVal g As Graphics, ByVal theFont As Font) _
        As Single
         Dim stringSize As SizeF = _
           g.MeasureString(myChar.ToString(), theFont)
         Return stringSize.Width
      End Function 'GetWidth


      Public Function GetHeight( _
        ByVal g As Graphics, ByVal theFont As Font) _
        As Single
         Dim stringSize As SizeF = _
           g.MeasureString(myChar.ToString(), theFont)
         Return stringSize.Height
      End Function 'GetHeight


      Public Sub DrawLetter( _
         ByVal g As Graphics, ByVal brush As Brush, _
         ByVal ctrl As ClockFaceCtrl)

         ' pobranie czcionki do rysowania
         Dim theFont As Font = ctrl.myFont

         ' pobranie pdzla, ktry ukryje poprzedni liter
         Dim blankBrush As SolidBrush = New SolidBrush(ctrl.BackColor)

         ' rysowanie na wczeniejszej lokalizacji (wykasowanie litery)
         g.DrawString(myChar.ToString(), theFont, _
           blankBrush, oldx, oldy)

         ' narysowanie litery w nowej lokalizacji przy uyciu 
         ' przekazanego pdzla
         g.DrawString(myChar.ToString(), _
           theFont, brush, X, Y)
      End Sub 'DrawLetter
   End Class 'LtrDraw

   Private Class StringDraw

      Private myLtrDrawList As Generic.List(Of LtrDraw) = _
          New Generic.List(Of LtrDraw)
      Private myLtrDraw As LtrDraw
      Private theControl As ClockFaceCtrl


      Public Sub New(ByVal s As String, _
        ByVal theControl As ClockFaceCtrl)
         Me.theControl = theControl
         Dim c As Char
         For Each c In s
            myLtrDraw = New LtrDraw(c)
            myLtrDrawList.Add(myLtrDraw)
         Next c
      End Sub 'New


      Public Sub DrawTheString( _
        ByVal g As Graphics, ByVal brush As Brush)
         Dim angle As Integer = 360 / myLtrDrawList.Count
         Dim counter As Integer = 0

         Dim theLtr As LtrDraw
         For Each theLtr In myLtrDrawList
            Dim newX As Single = _
              GetCos((angle * counter + _
              90 - ClockFaceCtrl.offset)) _
              * ClockFaceCtrl.DateRadius

            Dim newY As Single = _
              GetSin((angle * counter + 90 - _
              ClockFaceCtrl.offset)) * _
              ClockFaceCtrl.DateRadius

            ' wyrodkowanie liter
            theLtr.X = newX - theLtr.GetWidth( _
               g, theControl.myFont) / 2

            theLtr.Y = newY - theLtr.GetHeight( _
               g, theControl.myFont) / 2

            counter += 1

            theLtr.DrawLetter(g, brush, theControl)
         Next theLtr
         ClockFaceCtrl.offset += 1
      End Sub 'DrawString
   End Class 'StringDraw

   Protected Overrides Sub OnPaint(ByVal pe As System.Windows.Forms.PaintEventArgs)
      MyBase.OnPaint(pe)
      Dim g As Graphics = pe.Graphics
      SetScale(g)
      DrawFace(g)
      DrawTime(g, True)
   End Sub
   Private Shared Function _
      GetCos(ByVal degAngle As Single) As Single
      Return CSng(Math.Cos((Math.PI * degAngle / 180.0F)))
   End Function 'GetCos

   Private Shared Function _
      GetSin(ByVal degAngle As Single) As Single
      Return CSng(Math.Sin((Math.PI * degAngle / 180.0F)))
   End Function 'GetSin

   Public Sub New()
      MyBase.New()

      ' wywoanie jest wymagane przez Component Designer.
      InitializeComponent()

      BackColor = SystemColors.Window
      ForeColor = SystemColors.WindowText

      Dim today As String = System.DateTime.Now.ToLongDateString()
      today = " " + today.Replace(",", "")
      sdToday = New StringDraw(today, Me)

      currentTime = DateTime.Now
      Dim timer As New System.Timers.Timer()
      AddHandler timer.Elapsed, AddressOf OnTimer
      timer.Interval = 50
      timer.Enabled = True
   End Sub 'New 
   Public Property TwentyFourHours() As Boolean
      Get
         Return b24Hours
      End Get
      Set(ByVal Value As Boolean)
         b24Hours = Value
         Me.Invalidate()
      End Set

   End Property
   Public Sub OnTimer( _
   ByVal source As Object, _
   ByVal e As Timers.ElapsedEventArgs)
      Using g As Graphics = Me.CreateGraphics
         SetScale(g)
         CreateFont()
         DrawFace(g)
         DrawTime(g, False)
         DrawDate(g)
      End Using
   End Sub 'OnTimer

   Public Sub CreateFont()
      ' odczytanie rodziny czcionki ustawionej w form.ChangeClockFont
      Dim fntFamily As New FontFamily(Me.myFontFamily)

      ' inicjacja stylu zwykego i zmiana stylu na ustawiony w ChangeClockFont
      Dim fntStyle As FontStyle = FontStyle.Regular
      If Me.isBold Then fntStyle = FontStyle.Bold
      If Me.isItalic Then fntStyle = FontStyle.Italic
      If Me.isBold And Me.isItalic Then fntStyle = FontStyle.Bold Or FontStyle.Italic

      ' sprawdzenie, czy czcionka istnieje na komputerze
      ' jeli tak, ustawienie nowej czcionki
      ' jeli nie, wywietlenie okna komunikatu
      If fntFamily.IsStyleAvailable(fntStyle) Then
         Me.myFont = New Font(fntFamily, Me.FontSize, fntStyle)
      Else
         MessageBox.Show("Na tym komputerze czcionka jest nieprawidowa. Resetowanie...", _
             "Nieprawidowa czcionka", MessageBoxButtons.OK, MessageBoxIcon.Error)
      End If
   End Sub

   Private Sub SetScale(ByVal g As Graphics)
      If Width = 0 Or Height = 0 Then
         Return
      End If

      If Me.xCenter = 0 And Me.yCenter = 0 Then
         Me.xCenter = Width \ 2
         Me.yCenter = Height \ 2
      End If

      ' ustawienie pocztku w punkcie rodka
      g.TranslateTransform(xCenter, yCenter)

      Dim inches As Single = _
         Math.Min(Width / g.DpiX, Height / g.DpiX)

      g.ScaleTransform( _
         inches * g.DpiX / 2000, inches * g.DpiY / 2000)
   End Sub 'SetScale


   Private Sub DrawFace(ByVal g As Graphics)

      Dim brush As SolidBrush = New SolidBrush(ForeColor)
      Dim greenBrush As SolidBrush = New SolidBrush(Color.Green)

      Dim x, y As Single

      Dim numHours As Integer
      If b24Hours Then
         numHours = 24
      Else
         numHours = 12
      End If

      Dim deg As Integer = 360 / numHours

      Dim i As Integer
      For i = 1 To numHours
         Dim stringSize As SizeF = _
           g.MeasureString(i.ToString(), myFont)
         x = GetCos((i * deg + 90)) * FaceRadius
         y = GetSin((i * deg + 90)) * FaceRadius

         Dim format As New StringFormat()
         format.Alignment = StringAlignment.Center
         format.LineAlignment = StringAlignment.Center

         If currentTime.Second = i * 5 Then
            g.DrawString(i.ToString(), myFont, _
              greenBrush, -x, -y, format)
         Else
            g.DrawString(i.ToString(), myFont, _
              brush, -x, -y, format)
         End If
      Next i
   End Sub 'DrawFace

   Private Sub DrawTime( _
        ByVal g As Graphics, ByVal forceDraw As Boolean)

      ' zapisanie obecnej godziny
      Dim oldTime As DateTime = currentTime

      Dim secondBrush As SolidBrush = New SolidBrush(Color.Green)
      Dim blankBrush As SolidBrush = New SolidBrush(BackColor)
      DoDrawSecond(g, New SolidBrush(BackColor))

      Dim newTime As DateTime = DateTime.Now
      currentTime = newTime   ' ustawienie nowej godziny i uaktualnienie sekundnika
      DoDrawSecond(g, New SolidBrush(Color.Green))

      ' jesli rozpocza si nowa minuta
      If oldTime.Minute <> currentTime.Minute Or forceDraw Then
         currentTime = oldTime ' do usunicia
         Dim hourPen As New Pen(BackColor)
         Dim minutePen As New Pen(BackColor)
         hourPen.EndCap = Drawing2D.LineCap.ArrowAnchor
         minutePen.EndCap = Drawing2D.LineCap.ArrowAnchor
         hourPen.Width = 30
         minutePen.Width = 20
         DoDrawTime(g, hourPen, minutePen) ' usunicie
         currentTime = newTime   ' do narysowania nowej godziny
         hourPen.Color = Color.Red
         minutePen.Color = Color.Blue
         DoDrawTime(g, hourPen, minutePen) ' powtrne rysowanie
      End If

   End Sub 'DrawTime

   Private Sub DoDrawSecond( _
   ByVal g As Graphics, _
   ByVal secondBrush As SolidBrush)
      Dim secondLength As Single = FaceRadius * 0.9F
      Dim state As Drawing2D.GraphicsState = g.Save()
      Dim rotation As Single = GetSecondRotation()
      g.RotateTransform(rotation)
      g.FillEllipse(secondBrush, -25, -secondLength, 50, 50)
      g.Restore(state)
   End Sub


   Private Sub DoDrawTime( _
   ByVal g As Graphics, _
   ByVal hourPen As Pen, _
   ByVal minutePen As Pen)

      Dim hourLength As Single = FaceRadius * 0.5F
      Dim minuteLength As Single = FaceRadius * 0.7F
      Dim secondLength As Single = FaceRadius * 0.9F

      Dim state As Drawing2D.GraphicsState = g.Save()
      Dim rotation As Single = GetMinuteRotation()
      g.RotateTransform(rotation)
      g.DrawLine(minutePen, 0, 0, 0, -minuteLength)
      g.Restore(state)

      state = g.Save()
      rotation = GetHourRotation()
      g.RotateTransform(rotation)
      g.DrawLine(hourPen, 0, 0, 0, -hourLength)
      g.Restore(state)


   End Sub

   ' ustalenie obrotu rysowanej wskazwki zegara
   Private Function GetHourRotation() As Single
      ' liczba stopni zaley od tego, czy zegar ma 12, czy 24 godziny
      Dim deg As Single
      Dim numHours As Single
      If b24Hours Then
         deg = 15
         numHours = 24
      Else
         deg = 30
         numHours = 12
      End If

      Return 360.0F * currentTime.Hour / numHours + deg * _
        currentTime.Minute / 60.0F
   End Function 'GetHourRotation


   Private Function GetMinuteRotation() As Single
      Return 360.0F * currentTime.Minute / 60.0F '+
   End Function 'GetMinuteRotation
   ' 6f * currentTime.Second / 60f);

   Private Function GetSecondRotation() As Single
      Return 360.0F * currentTime.Second / 60.0F
   End Function 'GetSecondRotation

   Private Sub DrawDate(ByVal g As Graphics)
      Dim brush As SolidBrush = New SolidBrush(ForeColor)
      sdToday.DrawTheString(g, brush)
   End Sub 'DrawDate

   Private Sub ClockFaceCtrl_MouseClick( _
 ByVal sender As System.Object, _
 ByVal e As System.Windows.Forms.MouseEventArgs) _
 Handles MyBase.MouseClick
      Relocate(e)
   End Sub
   Private Sub ClockFaceCtrl_MouseDown( _
   ByVal sender As System.Object, _
   ByVal e As System.Windows.Forms.MouseEventArgs) _
   Handles MyBase.MouseDown
      Me.Cursor = Cursors.Hand
      Me.isMoving = True
   End Sub

   Private Sub ClockFaceCtrl_MouseUp( _
   ByVal sender As System.Object, _
   ByVal e As System.Windows.Forms.MouseEventArgs) _
   Handles MyBase.MouseUp
      Relocate(e)
      Me.Cursor = Cursors.Default
      Me.isMoving = False
   End Sub

   Private Sub Relocate(ByVal e As System.Windows.Forms.MouseEventArgs)
      Me.xCenter = e.X
      Me.yCenter = e.Y
      Me.Invalidate()
   End Sub

   Private Sub ClockFaceCtrl_MouseMove( _
   ByVal sender As System.Object, _
   ByVal e As System.Windows.Forms.MouseEventArgs) _
   Handles MyBase.MouseMove
      If isMoving = True Then Relocate(e)
   End Sub

   Private Sub ClockFaceCtrl_MouseEnter( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) Handles MyBase.MouseEnter
      Me.currentColor = Me.BackColor
      Me.BackColor = Color.Aqua
   End Sub

   Private Sub ClockFaceCtrl_MouseLeave( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) Handles MyBase.MouseLeave
      Me.BackColor = Me.currentColor
   End Sub
End Class
