Imports System.IO
Public Class frmText
   Private streamToPrint As StringReader
   Private Sub mnuFileOpen_Click( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) Handles mnuFileOpen.Click
      ' katalog pocztkowy, w ktrym maj by szukane pliki
      Me.OpenFileDialog1.InitialDirectory = "C:\Temp"

      ' filtr plikw
      Me.OpenFileDialog1.Filter = "Pliki tekstowe (*.txt) | *.txt"

      ' sprawdzenie, czy uytkownik klikn OK
      ' jeli tak, zaadowanie pliku do pola tekstowego,
      ' ustawienie typu pliku na tekstowy i ustawienie czcionki
      Dim result As DialogResult = Me.OpenFileDialog1.ShowDialog()
      If result = Windows.Forms.DialogResult.OK Then
         RichTextBox1.LoadFile( _
             OpenFileDialog1.FileName, _
             RichTextBoxStreamType.PlainText)
         RichTextBox1.SelectionFont = New Font("Verdana", 10)
      End If

   End Sub

   Private Sub mnuFileSave_Click( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) Handles mnuFileSave.Click
      Me.SaveFileDialog1.FileName = _
         Me.OpenFileDialog1.FileName
      Me.SaveFileDialog1.Filter = _
         Me.OpenFileDialog1.Filter
      Me.SaveFileDialog1.ShowDialog()

   End Sub

   Private Sub SaveFileDialog1_FileOk( _
   ByVal sender As System.Object, _
   ByVal e As System.ComponentModel.CancelEventArgs) _
   Handles SaveFileDialog1.FileOk

      Me.RichTextBox1.SaveFile( _
          Me.SaveFileDialog1.FileName, _
          RichTextBoxStreamType.RichText)
   End Sub


   Private Sub mnuFilePrint_Click( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) Handles mnuFilePrint.Click
      streamToPrint = New StringReader(Me.RichTextBox1.Text)
      Me.PrintDialog1.Document = PrintDocument1
      Dim dlgResult As DialogResult = Me.PrintDialog1.ShowDialog()
      If dlgResult = Windows.Forms.DialogResult.OK Then
         Try
            PrintDocument1.Print()
         Catch ex As Exception
            MessageBox.Show("Bd drukowania " + ex.Message)
         Finally
            streamToPrint.Close()
         End Try
      End If


   End Sub

   ' metoda wywoywana z mnuFilePrint_Click
   Private Sub PrintDocument1_PrintPage( _
   ByVal sender As System.Object, _
   ByVal e As System.Drawing.Printing.PrintPageEventArgs) _
   Handles PrintDocument1.PrintPage

      Dim printFont As Font = New Font("Verdana", 10)

      Dim linesPerPage As Single = 0
      Dim yPosition As Single = 0
      Dim ctr As Integer = 0
      Dim left As Single = e.MarginBounds.Left
      Dim top As Single = e.MarginBounds.Top
      Dim line As String = Nothing

      ' zliczenie liczby wierszy na stronie
      linesPerPage = e.MarginBounds.Height / _
          printFont.GetHeight(e.Graphics)

      While ctr < linesPerPage
         line = streamToPrint.ReadLine()
         If line Is Nothing Then
            Exit While
         End If
         yPosition = top + ctr * _
             printFont.GetHeight(e.Graphics)

         e.Graphics.DrawString( _
         line, _
         printFont, _
         Brushes.Black, _
         left, _
         yPosition, _
         New StringFormat())

         ctr += 1
      End While

      If line IsNot Nothing Then
         e.HasMorePages = True
      Else
         e.HasMorePages = False
      End If

   End Sub

End Class