Imports System.Collections.Generic
Imports System.Collections
Imports System.IO
Public Class frmFilesCopier

   Private Const MaxLevel As Integer = 2

   Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
      Me.Close()
   End Sub


   Private Sub GetSubDirectoryNodes( _
      ByVal parentNode As TreeNode, _
      ByVal fullName As String, _
      ByVal getFileNames As Boolean, _
      ByVal level As Int32)

      Dim dir As DirectoryInfo = New DirectoryInfo(fullName)
      Try
         Dim dirSubs As DirectoryInfo() = dir.GetDirectories()
         For Each dirsub As DirectoryInfo In dirSubs
            Dim subNode As TreeNode = New TreeNode(dirsub.Name)
            parentNode.Nodes.Add(subNode)
            If level < MaxLevel Then
               ' rekurencja
               GetSubDirectoryNodes( _
                   subNode, _
                   dirsub.FullName, _
                   getFileNames, _
                   level + 1)
            End If
         Next

         If getFileNames = True Then
            Dim files As FileInfo() = dir.GetFiles()
            For Each file As FileInfo In files
               Dim fileNode As TreeNode = New TreeNode(file.Name)
               parentNode.Nodes.Add(fileNode)
            Next

         End If
      Catch ex As Exception
         ' zignorowanie wyjtkw
      End Try
   End Sub
   Private Sub FillDirectoryTree( _
      ByVal tvw As TreeView, _
      ByVal getFiles As Boolean)
      tvw.Nodes.Clear()
      Dim strDrives As String() = Environment.GetLogicalDrives()
      For Each rootDirectoryName As String In strDrives
         Try
            Dim dir As DirectoryInfo = New DirectoryInfo(rootDirectoryName)
            '' wyrzucenie plikw lub wyjtku, jeli dysk nie jest gotowy
            dir.GetDirectories()
            Dim ndRoot As TreeNode = New TreeNode(rootDirectoryName)
            tvw.Nodes.Add(ndRoot)
            If (getFiles = True) Then
               GetSubDirectoryNodes(ndRoot, ndRoot.Text, True, 1)
            Else
               GetSubDirectoryNodes(ndRoot, ndRoot.Text, False, 1)
            End If

         Catch ex As Exception
            ' obsuga wyjtku
         End Try
      Next


   End Sub


   Private Sub frmFilesCopier_Load( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) Handles MyBase.Load
      Me.Cursor = Cursors.WaitCursor
      Me.FillDirectoryTree(Me.tvwSource, True)
      Me.FillDirectoryTree(Me.tvwTarget, False)
      Me.Cursor = Cursors.Default
   End Sub

   Private Sub tvwExpand(ByVal sender As System.Object, _
   ByVal e As System.Windows.Forms.TreeViewCancelEventArgs) _
   Handles tvwSource.BeforeExpand, tvwTarget.BeforeExpand

      Dim tvw As TreeView = CType(sender, TreeView)
      ''Dim getFiles As Boolean = (tvw.Name = "tvwSource")
      Dim getFiles As Boolean = False
      If tvw.Name = "tvwSource" Then getFiles = True

      Dim currentNode As TreeNode = e.Node
      Dim fullName As String = currentNode.FullPath
      currentNode.Nodes.Clear()
      GetSubDirectoryNodes(currentNode, fullName, getFiles, 1)

   End Sub

   Private Sub tvwSource_AfterCheck( _
   ByVal sender As System.Object, _
   ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles tvwSource.AfterCheck
      SetCheck(e.Node, e.Node.Checked)
   End Sub

   Private Sub SetCheck( _
   ByVal node As TreeNode, _
   ByVal check As Boolean)
      For Each n As TreeNode In node.Nodes
         n.Checked = check
         If n.Nodes.Count <> 0 Then
            SetCheck(n, check)
         End If
      Next
   End Sub

   Private Sub tvwTarget_AfterSelect( _
   ByVal sender As System.Object, _
   ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles tvwTarget.AfterSelect

      Dim theFullPath As String = GetParentString(e.Node)
      If theFullPath.EndsWith("\") Then
         theFullPath = theFullPath.Substring(0, theFullPath.Length - 1)
      End If
      Me.txtTarget.Text = theFullPath

   End Sub

   Private Function GetParentString(ByVal node As TreeNode) As String
      If node.Parent Is Nothing Then
         Return node.Text
      Else
         Dim endString As String = String.Empty
         If node.Nodes.Count <> 0 Then endString = "\"
         Return GetParentString(node.Parent) + node.Text + endString
      End If
   End Function

   Private Sub btnCopy_Click( _
    ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles btnCopy.Click

      Dim fileList As List(Of FileInfo) = GetFileList()

      For Each file As FileInfo In fileList
         Try
            lblStatus.Text = "Kopiowanie " + txtTarget.Text + "\" + file.Name + "..."
            Application.DoEvents()
            file.CopyTo(txtTarget.Text + "\" + file.Name, cbOverwrite.Checked)
         Catch ex As Exception
            MessageBox.Show(ex.Message)
         End Try
      Next
      lblStatus.Text = "Zakoczone"
      Application.DoEvents()
   End Sub

   Private Function GetFileList() As List(Of FileInfo)
      Dim fileNames As List(Of String) = New List(Of String)
      For Each theNode As TreeNode In tvwSource.Nodes
         GetCheckedFiles(theNode, fileNames)
      Next
      Dim fileList As List(Of FileInfo) = New List(Of FileInfo)
      For Each fileName As String In fileNames
         Dim file As FileInfo = New FileInfo(fileName)
         If file.Exists Then
            fileList.Add(file)
         End If
      Next

      Return fileList
   End Function

   Private Sub GetCheckedFiles( _
   ByVal node As TreeNode, _
   ByVal fileNames As List(Of String))
      If node.Nodes.Count = 0 Then
         If node.Checked Then
            fileNames.Add(GetParentString(node))
         End If
      Else
         For Each n As TreeNode In node.Nodes
            GetCheckedFiles(n, fileNames)
         Next
      End If

   End Sub

   Private Sub btnDelete_Click( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) Handles btnDelete.Click

      Dim result As DialogResult = MessageBox.Show( _
          "Jeste pewien?", _
          "Usuwanie plikw", _
          MessageBoxButtons.YesNo, _
          MessageBoxIcon.Exclamation, _
          MessageBoxDefaultButton.Button2)

      If result = Windows.Forms.DialogResult.Yes Then
         Dim fileNames As List(Of FileInfo) = GetFileList()
         For Each file As FileInfo In fileNames
            Try
               lblStatus.Text = "Usuwanie " + txtTarget.Text + "\" + file.Name + "..."
               Application.DoEvents()
               file.Delete()
            Catch ex As Exception
               MessageBox.Show(ex.Message)
            End Try
         Next
         lblStatus.Text = "Zakoczone"
         Application.DoEvents()
      End If


   End Sub

   Private Sub btnClear_Click( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) Handles btnClear.Click
      For Each node As TreeNode In tvwSource.Nodes
         SetCheck(node, False)
      Next
   End Sub
End Class