Imports System.Web
Imports System.Web.Services
Imports System.Web.Services.Protocols

<WebService(Namespace:="http://microsoft.com/webservices/")> _
<WebServiceBinding(ConformsTo:=WsiProfiles.None)> _
<Global.Microsoft.VisualBasic.CompilerServices.DesignerGenerated()> _
Public Class Service
   Inherits System.Web.Services.WebService
   Dim stocks As String(,) = _
{ _
   {"MSFT", "Microsoft", "25,22"}, _
   {"DELL", "Dell Computers", "42,12"}, _
   {"INTC", "Intel", "25,50"}, _
   {"YHOO", "Yahoo!", "30,81"}, _
   {"GE", "General Electric", "37,51"}, _
   {"IBM", "International Business Machines", "91,98"}, _
   {"GM", "General Motors", "64,72"}, _
   {"F", "Ford Motor Company", "25,05"} _
}

   <WebMethod()> _
   Public Function HelloWorld() As String
      Return "Hello World"
   End Function

   <WebMethod()> _
   Public Function GetPrice(ByVal StockSymbol As String) As Double
      Dim returnValue As Double = 0
      For counter As Integer = 0 To stocks.GetLength(0) - 1
         If (String.Compare(StockSymbol, stocks(counter, 0), True) = 0) Then
            returnValue = Convert.ToDouble(stocks(counter, 2))
         End If
      Next
      Return returnValue
   End Function

   <WebMethod()> _
   Public Function GetName(ByVal StockSymbol As String) As String
      Dim returnValue As String = "Symbol nieznany."
      For counter As Integer = 0 To stocks.GetLength(0) - 1
         If (String.Compare(StockSymbol, stocks(counter, 0), True) = 0) Then
            returnValue = stocks(counter, 1)
         End If
      Next
      Return returnValue
   End Function

   <WebMethod(Description:="Liczba wywoa w sesji.", EnableSession:=True)> _
   Public Function HitCounter() As Integer
      If Session("HitCounter") Is Nothing Then
         Session("HitCounter") = 1
      Else
         Session("HitCounter") = CInt(Session("HitCounter")) + 1
      End If
      Return CInt(Session("HitCounter"))
   End Function

   <WebMethod(Description:="Zwraca warto inwestycji uytkownika we wskazanej spce", _
           MessageName:="GetValueStockInPortfolio")> _
   Public Function GetValue(ByVal StockSymbol As String) As Double
      ' miejsce na kod metody
      Return 0
   End Function

   <WebMethod(Description:="Zwraca warto podanej liczby akcji danej spki", _
              MessageName:="GetValueThisManyShares")> _
   Public Function GetValue( _
   ByVal StockSymbol As String, _
   ByVal NumShares As Integer) As Double
      ' miejsce na kod metody
      Return 0
   End Function

End Class
