Option Strict On
Option Explicit On

Public Class RolodexPanel
   Public Const StartX As Integer = 32
   Public Const StartY As Integer = 24
   Public Const BufferSpace As Integer = 20
   Public Const ScrollBarWidth As Integer = 25
   Public Const RowsPerPage As Integer = 4
   Public Const ColsPerRow As Integer = 3
   Public Const NumEntriesPerPage As Integer = RowsPerPage * ColsPerRow

   '' zdarzenia
   Public Event RowFillEvent(ByVal sender As Object, ByVal e As EventArgs)
   Public Event ButtonSelectedEvent(ByVal sender As Object, ByVal e As EventArgs)
   Protected chosenLtr As Char
   Protected xIncr As Integer
   Protected yIncr As Integer
   Protected vsb As VScrollBar = New VScrollBar()
   Protected entry As RolodexEntry = Nothing

   ReadOnly Property ChosenLetter() As Char
      Get
         Return chosenLtr
      End Get
   End Property
   ReadOnly Property XIncrement() As Integer
      Get
         Return xIncr
      End Get
   End Property
   ReadOnly Property YIncrement() As Integer
      Get
         Return yIncr
      End Get
   End Property
   Property Vbar() As VScrollBar
      Get
         Return vsb
      End Get
      Set(ByVal value As VScrollBar)
         vsb = value
      End Set
   End Property
   ReadOnly Property SelectedEntry() As RolodexEntry
      Get
         Return entry
      End Get
   End Property
   Private Sub RolodexPanel_Load( _
      ByVal sender As System.Object, _
      ByVal e As System.EventArgs) Handles MyBase.Load
      Dim entry As RolodexCustomerEntry = New RolodexCustomerEntry()
      xIncr = entry.Width + Me.BufferSpace
      yIncr = entry.Height + Me.BufferSpace
      Me.pnlrolodex.Height = RowsPerPage * yIncr + StartY
      Me.pnlNavigationButtons.Top = Me.pnlrolodex.Bottom + BufferSpace
      Me.pnlrolodex.Width = Me.pnlrolodex.Width - ScrollBarWidth
      Me.pnlrolodex.AutoScroll = False
      vsb.SmallChange = ColsPerRow
      vsb.LargeChange = NumEntriesPerPage
      vsb.Parent = Me
      vsb.Location = New Point(pnlrolodex.Right, pnlrolodex.Top)
      vsb.Size = New Size(ScrollBarWidth, pnlrolodex.Height)
      vsb.Minimum = 0
      AddHandler vsb.ValueChanged, AddressOf vbar_ValueChanged
   End Sub
   Protected Sub vbar_ValueChanged( _
   ByVal sender As Object, ByVal e As EventArgs)
      RaiseEvent RowFillEvent(Me, New EventArgs())
   End Sub
   Private Sub LetterButton_Click( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) _
   Handles btnZ.Click, btnY.Click, btnX.Click, btnW.Click, btnV.Click, btnU.Click, _
   btnT.Click, btnS.Click, btnR.Click, btnQ.Click, btnP.Click, btnO.Click, btnN.Click, _
   btnM.Click, btnL.Click, btnK.Click, btnJ.Click, btnI.Click, btnH.Click, btnG.Click, _
   btnF.Click, btnE.Click, btnD.Click, btnC.Click, btnB.Click, btnA.Click
      Me.entry = Nothing
      Dim oldCursor As Cursor = Me.Cursor
      Me.Cursor = Cursors.WaitCursor
      Dim btn As Button = CType(sender, Button)
      Dim letter As Char = CType("A", Char)
      If btn IsNot Nothing Then
         letter = CChar(btn.Text.ToUpper())
         Me.LoadRolodex(letter)
      End If
      Me.Cursor = oldCursor
      RaiseEvent ButtonSelectedEvent(sender, e)

   End Sub

   Protected Sub LoadRolodex()
      LoadRolodex(CType("A", Char))
   End Sub

   Protected Sub LoadRolodex(ByVal letter As Char)
      Me.chosenLtr = letter
   End Sub
   Public Sub Add(ByVal c As Control)
      Me.pnlrolodex.Controls.Add(c)
   End Sub
   Public Sub Clear()
      Me.pnlrolodex.Controls.Clear()
   End Sub
   Public Sub entry_click( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs)
      entry = CType(sender, RolodexEntry)
      For Each c As Control In Me.pnlrolodex.Controls
         Try
            Dim re As RolodexEntry = CType(c, RolodexEntry)
            re.Selected = False
         Catch ex As Exception
            Continue For
         End Try
      Next
      entry.Selected = True
   End Sub
End Class
