Public Class frmSuppliers
   Private m_CompanyNameParameter As String
   Private m_Dirty As Boolean = False
   Private ReadOnly formName As String = "Dostawcy"


   Public WriteOnly Property CompanyNameParameter() As String
      Set(ByVal value As String)
         m_CompanyNameParameter = value
      End Set
   End Property

   Private Sub frmSuppliers_Load( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) Handles MyBase.Load
      LoadFromDB()
      Dim ctrl As Control
      Dim txtbox As TextBox
      Dim dgv As DataGridView
      For Each ctrl In Me.Controls
         If TypeOf ctrl Is TextBox Then
            txtbox = CType(ctrl, TextBox)
            txtbox.Enabled = False
            AddHandler txtbox.ModifiedChanged, AddressOf TextBoxChanged
         ElseIf TypeOf ctrl Is DataGridView Then
            dgv = CType(ctrl, DataGridView)
            dgv.Enabled = False
            AddHandler dgv.CellValueChanged, AddressOf DataGridChanged
         End If
      Next
      Me.Text = formName + " - tylko do odczytu"
   End Sub

   Private Sub StopEditing()
      Dim ctrl As Control
      For Each ctrl In Me.Controls
         If TypeOf ctrl Is DataGridView Or TypeOf ctrl Is TextBox Then
            ctrl.Enabled = False
         End If
      Next
      Me.Text = formName + " - tylko do odczytu"
   End Sub

  

   Private Sub LoadFromDB()
      Me.SuppliersTableAdapter.FillByCompanyName( _
      Me.NorthwindDataSet.Suppliers, Me.m_CompanyNameParameter)
      Me.ProductsTableAdapter.Fill(Me.NorthwindDataSet.Products)
   End Sub

   Private Sub EditToolStripMenuItem_Click( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) Handles EditToolStripMenuItem.Click
      Dim ctrl As Control
      For Each ctrl In Me.Controls
         ctrl.Enabled = True
      Next
      Me.Text = formName + " - gotowe do edycji"
   End Sub

   ' procedura obsugi zdarzenia
   Private Sub DataGridChanged( _
   ByVal sender As System.Object, _
   ByVal e As System.Windows.Forms.DataGridViewCellEventArgs)
      DataChanged()
   End Sub

   ' procedura obsugi zdarzenia
   Private Sub TextBoxChanged( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs)
      DataChanged()
   End Sub

   ' metoda pomocnicza
   Private Sub DataChanged()
      Me.m_Dirty = True
      Me.Text = formName + " - zmienione, nie zapisane."
   End Sub

   Private Sub CancelToolStripMenuItem_Click( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) Handles CancelToolStripMenuItem.Click

      Dim doCancel As Boolean = True
      If Me.m_Dirty = True Then
         Dim result As DialogResult = _
            MessageBox.Show( _
               "Dokonane zmiany nie zostay zapisane. Na pewno chcesz anulowa operacj?", _
               "Moliwa utrata niezapisanych zmian", _
               MessageBoxButtons.YesNo, _
               MessageBoxIcon.Warning)
         If result = DialogResult.No Then
            doCancel = False
         End If
      End If

      If doCancel = True Then
         LoadFromDB()
         StopEditing()
         m_Dirty = False
      End If

   End Sub


   Private Sub SaveToolStripMenuItem_Click( _
   ByVal sender As System.Object, _
   ByVal e As System.EventArgs) Handles SaveToolStripMenuItem.Click
      Me.SuppliersBindingSource.EndEdit()

      If m_Dirty = True Then
         Dim tbChanges As Data.DataTable = _
            Me.NorthwindDataSet.Suppliers.GetChanges()

         If Not tbChanges Is Nothing Then
            Me.SuppliersTableAdapter.Update(tbChanges)
         End If

         tbChanges = Me.NorthwindDataSet.Products.GetChanges()
         If Not tbChanges Is Nothing Then
            Me.ProductsTableAdapter.Update(tbChanges)
         End If
      End If

      StopEditing()

   End Sub
End Class

