﻿Namespace CarPerformance
    Public Class Car
        Public Color As String
        Public HorsePower As Integer
        Private intSpeed As Integer
        Private intNumberOfDoors As Integer

        'Konstruktor.
        Public Sub New()
            'Ustawienie wartości domyślnych.
            Color = "Biały"
            intSpeed = 0
            intNumberOfDoors = 5
        End Sub


        'Speed - właściwość tylko do odczytu zwracająca prędkość.
        Public ReadOnly Property Speed() As Integer
            Get
                Return intSpeed
            End Get
        End Property

        'Accelerate - dodaje liczbę kilometrów na godzinę do prędkości.
        Public Sub Accelerate(ByVal accelerateBy As Integer)
            'Zmiana prędkości.
            intSpeed += accelerateBy
        End Sub

        'NumberOfDoors - pobiera i ustawia liczbę drzwi.
        Public Property NumberOfDoors() As Integer
            'Wywoływana przy odczycie właściwości.
            Get
                Return intNumberOfDoors
            End Get
            'Wywoływana przy zapisie właściwości.
            Set(ByVal value As Integer)
                'Czy nowa wartość mieści się w przedziale 2-5?
                If value >= 2 And value <= 5 Then
                    intNumberOfDoors = value
                End If
            End Set
        End Property

        'IsMoving - czy samochód się porusza?
        Public Function IsMoving() As Boolean
            'Czy prędkość samochodu to 0?
            If Speed = 0 Then
                Return False
            Else
                Return True
            End If
        End Function

        'CalculateAccelerationRate - w przypadku zwykłych samochodów zwraca stałą wartość.
        Public Overridable Function CalculateAccelerationRate() As Double
            'Zakładając, że zwykły samochód przyspiesza od 0 do 100 w 14 sekund,
            'średnie przyspieszenie to około 7,1.
            Return 7.1
        End Function

    End Class

End Namespace
