﻿Public Class Generics(Of elementType)
    'Ta klasa stanowi ilustrację zastosowania typów generycznych.

    'Deklaracja zmiennych prywatnych.
    Private strKey() As String
    Private elmValue() As elementType

    Public Sub Add(ByVal key As String, ByVal value As elementType)
        'Sprawdzanie, czy obiekty zostały zainicjowane.
        If strKey IsNot Nothing Then
            'Obiekty zostały zainicjowane.
            ReDim Preserve strKey(strKey.GetUpperBound(0) + 1)
            ReDim Preserve elmValue(elmValue.GetUpperBound(0) + 1)
        Else
            'Inicjowanie obiektów.
            ReDim strKey(0)
            ReDim elmValue(0)
        End If

        'Ustawianie wartości.
        strKey(strKey.GetUpperBound(0)) = key
        elmValue(elmValue.GetUpperBound(0)) = value
    End Sub

    Public ReadOnly Property Key(ByVal Index As Integer) As String
        Get
            Return strKey(Index)
        End Get
    End Property

    Public ReadOnly Property Value(ByVal Index As Integer) As elementType
        Get
            Return elmValue(Index)
        End Get
    End Property
End Class
