﻿using System.Collections.Generic;
using UnityEngine;
public class SkryptPanaBurgera : MonoBehaviour
{
    // To pole określa o ile każdy obiekt jest przesunięty od początkowej pozycji
    public float PrzesuniecieJednegoObiektu = -1f    ;
    public bool WylaczDzialaNaStarcie = false;
    private List<GameObject> _dziala;
    private GameObject _startowyObiekt, _koncowyObiekt;
    void Start()
    {
        _dziala = new List<GameObject>();
        for (int i = 0; i < transform.childCount; i++)
        {
            if (transform.GetChild(i).name == "PanBurgerDol")
                _koncowyObiekt = transform.GetChild(i).gameObject;
            if (transform.GetChild(i).name == "PanBurgerGora")
                _startowyObiekt = transform.GetChild(i).gameObject;
            if (transform.GetChild(i).name.Contains("Dzialo"))
                _dziala.Add(transform.GetChild(i).gameObject);
        }
        if(WylaczDzialaNaStarcie)
            for (int i = 1; i < _dziala.Count; i++)
                _dziala[i].SetActive(false);
        PrzesunObiekty();
    }
    public void AktualizujDzialo(string ktoreDzialo)
    {        
        for (int i = 0; i < _dziala.Count; i++)
            if (_dziala[i].name == ktoreDzialo)
            {
                if(_dziala[i].activeInHierarchy)
                {
                    OnOffAction wlacznik = _dziala[i].transform.GetComponentInChildren<OnOffAction>();
                    if(wlacznik != null)
                    {
                        wlacznik.ExecuteAction(null);
                        wlacznik.gameObject.SetActive(false);
                    }
                }
                else _dziala[i].SetActive(true);
            }
        PrzesunObiekty();
    }
    private void PrzesunObiekty()
    {
        float przesuniecie = PrzesuniecieJednegoObiektu;
        for (int i = 0; i < _dziala.Count; i++)
        {
            if (_dziala[i].activeInHierarchy)
            {
                _dziala[i].transform.localPosition = new Vector3(_dziala[i].transform.localPosition.x, _startowyObiekt.transform.localPosition.y + przesuniecie, _dziala[i].transform.localPosition.z);
                przesuniecie += PrzesuniecieJednegoObiektu;
            }
        }
        _koncowyObiekt.transform.localPosition = new Vector3(_koncowyObiekt.transform.localPosition.x, _startowyObiekt.transform.localPosition.y + przesuniecie, _koncowyObiekt.transform.localPosition.z);
    }
}
