using UnityEngine;

public class AutoMoveNoPhysics : MonoBehaviour
{
	// This is the constant non-physical movement that will move the object every frame
	// don't forget they can be negative too!
	public Vector2 direction = new Vector2(1f, 0f);
    
	//is the push relative or absolute to the world?
	public bool relativeToRotation = true;

	
	// FixedUpdate is called once per frame
	void FixedUpdate ()
	{
		if(relativeToRotation)
		{
            transform.localPosition = new Vector2(transform.localPosition.x + direction.x, transform.localPosition.y + direction.y);
		}
		else
		{
            transform.position = new Vector2(transform.position.x + direction.x, transform.position.y + direction.y);
        }
	}


	//Draw an arrow to show the direction in which the object will move
	void OnDrawGizmosSelected()
	{
		if(this.enabled)
		{
			float extraAngle = (relativeToRotation) ? transform.rotation.eulerAngles.z : 0f;
			Utils.DrawMoveArrowGizmo(transform.position, direction, extraAngle);
		}
	}
}
