﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Sadzonka : MonoBehaviour {

    public GameObject Roslina;

	// Use this for initialization
	void Start () {

        // sprawdzamy, czy w edytorze na pewno zostało ustawione pole Roslina 
        if (Roslina == null)
            Debug.LogError("Brak ustawienia pola Roslina! ");
        // na starcie dorosła roślina ma zniknąć
        Transform transformRosliny = Roslina.GetComponent<Transform>();
        // GetComponentInChildren<Renderer>() szuka komponentu Renderer w podobiektach tego obiektu;
        // szukamy renderera obiektu o nazwie RoslinaX_Obiekt
        Renderer rendererRosliny = transformRosliny.GetComponentInChildren<Renderer>();
        rendererRosliny.enabled = false;
	}
	
    private void OnCollisionEnter(Collision collision)
    {
        Gracz obiektGracz = collision.collider.GetComponent<Gracz>();
        obiektGracz.NiesionaSadzonka = this;
        // wyłączamy sadzonkę
        WlaczRenderer(false);
        WlaczCollider(false);       
    }

    public void WlaczCollider(bool CzyWlaczyc)
    {
        Collider ColliderSadzonki = GetComponentInChildren<Collider>();
        ColliderSadzonki.enabled = CzyWlaczyc;
    }
    public void WlaczRenderer(bool CzyWlaczyc)
    {
        Renderer RendererSadzonki = GetComponentInChildren<Renderer>();
        RendererSadzonki.enabled = CzyWlaczyc;
    }

}
