﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.Events;

// Tak klasa wywołuje zdarzenie Unity (UnityEvent) kiedy obiekt gracza
// (obiekt ze znacznikiem "Player") uderzy w jakiś inny obiekt
[RequireComponent (typeof(Collider2D))]
public class SignalOnTouch : MonoBehaviour {

	// Zdarzenie Unity, które należy wygenerować w momencie uderzenia
	// w inny obiekt. Metody, które należy wykonać w celu obsługi tego 
	// zdarzenia można określać w edytorze Unity.
	public UnityEvent onTouch;

	// Jeśli właściwość ta ma wartość true, to zderzenie z innym 
	// obiektem powinno powodować odtworzenie klipu dźwiękowego
	public bool playAudioOnTouch = true;

	// Kiedy wejdziemy w obszar wyzwalania, wywoływana jest metoda SenSignal
	void OnTriggerEnter2D(Collider2D collider) {
		SendSignal (collider.gameObject);
	}

	// W przypadku zderzenia z tym obiektem, wywoływana jest metoda SendSignal
	void OnCollisionEnter2D(Collision2D collision) {
		SendSignal (collision.gameObject);
	}

	// Metoda sprawdza czy obiekt ma znacznik "Player", a jeśli ma, 
	// to generuje zdarzenie Unity
	void SendSignal(GameObject objectThatHit) {

		// Czy obiekt ma znacznik "Player"?
		if (objectThatHit.CompareTag("Player")) {

			// Jeśli należy odtworzyć klip dźwiękowy, to próbujemy go odtworzyć
			if (playAudioOnTouch) {
				var audio = GetComponent<AudioSource>();

				// Jeśli mamy komponent audio oraz jeśli komponent nadrzędny tego 
				// komponentu jest aktywny, to odtwarzamy klip 
				if (audio && audio.gameObject.activeInHierarchy)
					audio.Play();
			}

			// Generujemy zdarzenie
			onTouch.Invoke();
		}
	}

}
