﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class AsteroidSpawner : MonoBehaviour {

	// Promień obszaru, w którym będą tworzone asteroidy
	public float radius = 250.0f;

	// Asteroidy do tworzenia
	public Rigidbody asteroidPrefab;

	// Czas oczekiwania (spawnRate ± variance) pomiędzy momentami utworzenia
	// kolejnych asteroid
	public float spawnRate = 5.0f;
	public float variance = 1.0f;

	// Obiekt, w kierunku którego należy wysyłać asteroidy
	public Transform target;

	// Jeśli właściwość ta przyjmie wartość false, to przerywamy tworzenie
	// asteroid
	public bool spawnAsteroids = false;

	void Start () {
		// Uruchamiamy koprocedurę, która natychmiast utworzy jedną asteroidę

		StartCoroutine(CreateAsteroids());
	}

	IEnumerator CreateAsteroids() {
		
		// Pętla nieskończona
		while (true) {

			// Wyznaczamy współrzędne punktu, w którym pojawi się następna asteroida
			float nextSpawnTime = spawnRate + Random.Range(-variance, variance);

			// Czekamy określoną liczbę sekund
			yield return new WaitForSeconds(nextSpawnTime);

			// Dodatkowo czekamy na zaktualizowanie fizyki
			yield return new WaitForFixedUpdate();

			// Tworzymy asteroidę
			CreateNewAsteroid();
		}

	}

	void CreateNewAsteroid() {

		// Jeśli aktualnie nie mamy tworzyć asteroid, to kończymy
		if (spawnAsteroids == false) {
			return;
		}

		// Wybieramy losowy punkt na powierzchni kuli
		var asteroidPosition = Random.onUnitSphere * radius;

		// Skalujemy obiekt zgodnie z jego skalą
		asteroidPosition.Scale(transform.lossyScale);

		// I przesuwamy o odcinek zależny od lokalizacji obiektu generującego asteroidy
		asteroidPosition += transform.position;

		// Tworzymy nową asteroidę
		var newAsteroid = Instantiate(asteroidPrefab);

		// Umieszczamy asteroidę w miejscu wyznaczonym przed chwilą
		newAsteroid.transform.position = asteroidPosition;

		// Kierujemy asteroidę do celu
		newAsteroid.transform.LookAt(target);
	}

	// Metoda wywoływana przez edytor w momencie zaznaczenia obiektu generującego
	void OnDrawGizmosSelected() {

		// Chcemy zaznaczyć obiekt na żółto
		Gizmos.color = Color.yellow;

		// Nakazujemy zastosowanie aktualnego położenia i skali
		Gizmos.matrix = transform.localToWorldMatrix;

		// Rysujemy kulę reprezentującą obszar, w którym pojawiła się asteroida
		Gizmos.DrawWireSphere(Vector3.zero, radius);
	}

	public void DestroyAllAsteroids() {
		// Usuwamy z gry wszystkie asteroidy
		foreach (var asteroid in FindObjectsOfType<Asteroid>()) {
			Destroy (asteroid.gameObject);
		}
	} 
}
