﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

// Zapewnia dostęp do klas interfejsu użytkownika
using UnityEngine.UI;

public class Indicator : MonoBehaviour {

	// Śledzony obiekt
	public Transform target;

	// Pomiar odległości od celu (target) to tego obiektu
	public Transform showDistanceTo;

	// Etykieta prezentująca mierzoną odległość
	public Text distanceLabel;

	// Docelowa odległość od krawędzi ekranu
	public int margin = 50;

	// Odcień obrazka
	public Color color {
		set {
			GetComponent<Image>().color = value;
		}
		get {
			return GetComponent<Image>().color;
		}
	} 

	// Metoda odpowiadająca za skonfigurowanie wskaźnika
	void Start() {
		// Ukrywamy etykietę; zostanie ona ponownie wyświetlona w metodzie
		// Update, jeśli zostanie określony śledzony obiekt (target)
		distanceLabel.enabled = false;

		// Na początku, czekamy z wyświetleniem jedną klatkę, by uniknąć
		// wizualnych usterek
		GetComponent<Image>().enabled = false;

	}

	// Metoda aktualizuje położenie wskaźnika w każdej klatce
	void Update()
	{

		// Czy śledzony element wciąż istnieje? Jeśli nie, to znacznik
		// też należy usunąć
		if (target == null) {
			Destroy (gameObject);
			return;
		}

		// Jeśli istnieje element docelowy do którego odległość mamy 
		// zmierzyć, to mierzymy mą i wyświetlamy w obiekcie distanceLabel
		if (showDistanceTo != null) {

			// Wyświetlamy etykietę
			distanceLabel.enabled = true;

			// Obliczamy odległość
			var distance = (int)Vector3.Magnitude(
				showDistanceTo.position - target.position);

			// Wyświetlamy odległość w etykiecie
			distanceLabel.text = distance.ToString() + "m";
		} else {
			// Nie pokazujemy etykiety
			distanceLabel.enabled = false;
		}

		GetComponent<Image>().enabled = true;

		// Określamy położenie obiektu w przestrzeni ekranu
		var viewportPoint = Camera.main.WorldToViewportPoint(target.position);

		// Czy punkt jest za nami
		if (viewportPoint.z < 0) {
			// Jeśli tak, to przesuwamy go do krawędzi ekranu
			viewportPoint.z = 0;
			viewportPoint = viewportPoint.normalized;
			viewportPoint.x *= -Mathf.Infinity;
		} 

		// Określamy gdzie obiekt ma się znaleźć w przestrzeni widoku
		var screenPoint = Camera.main.ViewportToScreenPoint(viewportPoint);

		// Wyświetlamy przy krawędzi
		screenPoint.x = Mathf.Clamp(screenPoint.x, margin, Screen.width - margin * 2);  
		screenPoint.y = Mathf.Clamp(screenPoint.y, margin, Screen.height - margin * 2);


		// Przeliczamy współrzędne widoku na współrzędne obiektu Canvas
		var localPosition = new Vector2();
		RectTransformUtility.ScreenPointToLocalPointInRectangle(
			transform.parent.GetComponent<RectTransform>(), 
			screenPoint, 
			Camera.main, 
			out localPosition);

		// Aktualizujemy położenie wskaźnika
		var rectTransform = GetComponent<RectTransform>();
		rectTransform.localPosition = localPosition;

	}
}
