﻿using UnityEngine;
using System.Collections;

public class Boundary : MonoBehaviour {

	// Kiedy położenie statku od środka sfery przekroczy tę wartość,
	// należy wyświetlić ostrzeżenie
	public float warningRadius = 400.0f;

	// Kiedy położenie statku od środka sfery przekroczy tę wartość,
	// należy zakończyć grę
	public float destroyRadius = 450.0f;

	public void OnDrawGizmosSelected() {
		// Wyświetlamy żółtą sferę ostrzegawczą o promieniu warningRadius 
		Gizmos.color = Color.yellow;
		Gizmos.DrawWireSphere(transform.position, warningRadius);

		// Wyświetlamy czerwoną sferę zniszczenia o promieniu destroyRadius
		Gizmos.color = Color.red;
		Gizmos.DrawWireSphere(transform.position, destroyRadius);
	}
}
