﻿using UnityEngine;
using System.Collections;

// Przekształca dane z akcelerormetru na informacje o ruchu na boki
public class InputManager : Singleton<InputManager> {

	// O ile się przesuwamy? -1.0 - z pełną szybkością w lewo
	// +1.0 - z pełną szybkością na prawo
	private float _sidewaysMotion = 0.0f;

	// Ta właściwość została zadeklarowana jako tylko do odczytu,
	// a zatem inne klasy nie będą mogły jej modyfikować
	public float sidewaysMotion {
		get {
			return _sidewaysMotion;
		}
	}

	// Podczas obsługi każdej ramki, zapisujemy przechylenie
	void Update () {
		Vector3 accel = Input.acceleration;

		_sidewaysMotion = accel.x;
	}
}
