﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[RequireComponent (typeof(SpriteRenderer))]
public class BodyPart : MonoBehaviour {

	// Sprajt, którego należy użyć kiedy metoda ApplyDamageSprite
	// zostanie wywołana z parametrem damageType typu Slicing
	public Sprite detachedSprite;

	// Sprajt, którego należy użyć kiedy metoda ApplyDamageSprite
	// zostanie wywołana z parametrem damageType typu Burned
	public Sprite burnedSprite;

	// Reprezentuje położenie i rotację fontanny krwi wyświetlana
	// przy korpusie krasnala
	public Transform bloodFountainOrigin;

	// Jeśli ta właściwość przyjmie wartość true, to kolizje, złączenia
	// i komponent RigidBody zostaną usunięte z tego obiektu, gdy 
	// przestanie się on poruszać
	bool detached = false;

	// Metoda odłącza ten obiekt od obiektu nadrzędnego i oznacza 
	// konieczność pozbawienia go fizyki
	public void Detach() {
		detached = true;

		this.tag = "Untagged";

		transform.SetParent(null, true);
	}

	// Metoda wykonywana podczas generowania każdej ramki. Jeśli obiekt jest 
	// odłączony i jeśli wywołanie IsSleeping zwróci true, to usuwamy
	// wszelkie komponenty związane z fizyką. Dzięki temu ten odłączony
	// obiekt nigdy nie będzie przeszkadzać krasnalowi.
	public void Update() {

		// Jeśli obiekt nie jest odłączony, nic nie robimy
		if (detached == false) {
			return;
		}

		// Sprawdzamy stan komponentu RigidBody
		var rigidbody = GetComponent<Rigidbody2D>();

		if (rigidbody.IsSleeping()) {

			// Usuwamy wszystkie złączenia
			foreach (Joint2D joint in GetComponentsInChildren<Joint2D>()) {
				Destroy (joint);
			}

			// ... komponenty Rigidbody ...
			foreach (Rigidbody2D body in GetComponentsInChildren<Rigidbody2D>()) {
				Destroy (body);
			}

			// ... komponenty do wykrywania kolizji
			foreach (Collider2D collider in GetComponentsInChildren<Collider2D>()) {
				Destroy (collider);
			}

			// I w końcu usuwamy ten skrypt
			Destroy (this);
		}
	}

	// Ta metoda podmienia sprajt tej części działa krasnala, 
	// zależnie od jego obrażeń
	public void ApplyDamageSprite(Gnome.DamageType damageType) {

		Sprite spriteToUse = null;

		switch (damageType) {

		case Gnome.DamageType.Burning:
			spriteToUse = burnedSprite;

			break;

		case Gnome.DamageType.Slicing:
			spriteToUse = detachedSprite;

			break;
		}

		if (spriteToUse != null) {
			GetComponent<SpriteRenderer>().sprite = spriteToUse;
		}
	}
}
