﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class DamageTaking : MonoBehaviour {

	// Liczba punktów trafień, którymi dysponuje obiekt
	public int hitPoints = 10;

	// Jeśli obiekt ulegnie zniszczeniu, to w jego bieżącej 
	// lokalizacji utworzymy jeden z tych obiektów
	public GameObject destructionPrefab;

	// Czy należy zakończyć grę kiedy ten obiekt ulegnie zniszczeniu?
	public bool gameOverOnDestroyed = false;

	// Metoda wywoływana przez inne obiekty (takie jak asteroidy i strzały)
	// w celu zarejestrowania uszkodzeń
	public void TakeDamage(int amount) {

		// Informujemy, że obiekt doznał uszkodzeń
		Debug.Log(gameObject.name + " uszkodzony!");

		// Redukujemy odpowiednią liczbę punktów trafień
		hitPoints -= amount;

		// Czy obiekt uległ zniszczeniu?
		if (hitPoints <= 0) {

			// Rejestrujemy fakt zniszczenia obiektu
			Debug.Log(gameObject.name + " zniszczony!");

			// Usuwamy obiekt z gry
			Destroy(gameObject);

			// Czy mamy prefabrykat zniszczenia, który należy wyświetlić?
			if (destructionPrefab != null) {

				// Tworzymy obiekt w bieżącej lokalizacji i uwzględniamy rotację
				Instantiate(destructionPrefab, 
					transform.position, transform.rotation);
			}

			// Jeśli już teraz należy zakończyć grę, to wywołujemy metodę GameOver
			// obiektu GameManager
			if (gameOverOnDestroyed == true) {
				GameManager.instance.GameOver();
			}
		}

	}

}
