﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Asteroid : MonoBehaviour {

	// Szybkość ruchu asteroidy
	public float speed = 10.0f;

	void Start () {
		// Określamy szybkość komponentu Rigidbody
		GetComponent<Rigidbody>().velocity = transform.forward * speed;

		// Tworzymy dla asteroidy wskaźnik koloru czerwonego
		var indicator = IndicatorManager.instance.AddIndicator(gameObject, Color.red);

		// Śledzimy odległość pomiędzy tym obiektem a aktualną stacją kosmiczną
		// zarządzaną przez obiekt GameManager
		indicator.showDistanceTo = GameManager.instance.currentSpaceStation.transform;
	}

}
