﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class InputManager : Singleton<InputManager> {

	// Obiekt joysticka używany do sterowania statkiem
	public VirtualJoystick steering;

	// Długość okresu czasu (w sekundach) pomiędzy kolejnymi strzałami
	public float fireRate = 0.2f;

	// Aktualny skrypt ShipWeapons używany do oddawania strzałów
	private ShipWeapons currentWeapons;

	// Jeśli statek aktualnie strzela, właściwość na ma wartość true
	private bool isFiring = false;

	// Metoda wywoływana przez ShipWeapons w celu aktualizacji wartości 
	// zmiennej currentWeapons 
	public void SetWeapons(ShipWeapons weapons) {
		this.currentWeapons = weapons;
	}

	// Jak wyżej, wywoływana w celu wyzerowania zmiennej currentWeapons
	public void RemoveWeapons(ShipWeapons weapons) {

		// Jeśli obiekt currentWeapons to 'weapons', to zapisujemy w niej null
		if (this.currentWeapons == weapons) {
			this.currentWeapons = null;
		}
	}

	// Metoda wywoływana kiedy gracz wciśnie przycisk Fire
	public void StartFiring() {

		// Wywołujemy procedurę rozpoczynającą strzelanie
		StartCoroutine(FireWeapons());
	}

	IEnumerator FireWeapons() {

		// Oznaczamy, że aktualnie statek strzela
		isFiring = true;

		// Działamy w pętli, tak długo jak isFiring ma wartość true
		while (isFiring) {

			// Jeśli skrypt ShipWeapons jest dostępny, każdemu mu strzelać!
			if (this.currentWeapons != null) {
				currentWeapons.Fire();
			}

			// Czekamy przez fireRate sekund, a następnie oddajemy następny strzał
			yield return new WaitForSeconds(fireRate);

		}

	}

	// Metoda jest wywoływana kiedy gracz skończy naciskać przycisk Fire
	public void StopFiring() {

		// Zapisujemy w tej zmiennej false, by zakończy pętlę w FireWeapons
		isFiring = false;
	}

}

