﻿using UnityEngine;
using System.Collections;

// Klasa używa menedżera wejścia, by przykładać siły do obiektu.
// Używamy jej by przesuwać krasnala na boki.
public class Swinging : MonoBehaviour {

	// O ile należy przesunąć krasnala? Im większa liczba, tym 
	// większe przesunięcie
	public float swingSensitivity = 100.0f;

	// W celu zapewnienia lepszego współdziałania z systemem fizyki,
	// używamy metody FixedUpdate, a nie Update
	void FixedUpdate() {

		// Jeśli nie ma (już) Rigidbody, usuwamy komponent
		if (GetComponent<Rigidbody2D>() == null) {
			Destroy (this);
			return;
		}

		// Pobieramy wielkość wychylenia z obiektu InputManager
		float swing = InputManager.instance.sidewaysMotion;

		// Obliczenie siły, jaką należy zastosować
		Vector2 force = new Vector2(swing * swingSensitivity, 0);

		// Zastosowanie siły
		GetComponent<Rigidbody2D>().AddForce(force);
	}
}
