﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

// Klasa usuwa obiekt po określonym czasie
public class RemoveAfterDelay : MonoBehaviour {

	// Liczba sekund, jakie należy odczekać przed usunięciem obiektu
	public float delay = 1.0f;

	void Start () {
		// Uruchamiamy koprocedurę 'Remove' 
		StartCoroutine("Remove");
	}

	IEnumerator Remove() {
		// Czekamy liczę sekund określoną właściwością 'delay',
		// a następnie usuwamy gameObject skojarzony z tym obiektem
		yield return new WaitForSeconds(delay);
		Destroy (gameObject);

		// Nie można użyć wywołania Destroy(this) - w efekcie zostałby
		// usunięty jedynie ten skrypt (RemoveAfterDelay)
	}
}
