using UnityEngine;
using System.Collections;

public class ControllerScript : MonoBehaviour {
	
	CharacterController controller;
	
	Vector3 movement = Vector3.zero;
	public float speed = 6.0f;
	
	//sprinting speed
	public float sprintSpeed = 10.0f;
    public float jumpSpeed = 8.0f;
	public float pushPower = 2.0f;
	
	//has the player used their double jump?
	private bool doubleJump = false;
	
	void Start () {
		controller = GetComponent<CharacterController>();
	}
	
    void Update() {
		
		if(controller.isGrounded == false){
        	movement.y += Physics.gravity.y * Time.deltaTime;
			
			//allow the player to jump in air if they haven't already
			if(Input.GetButtonDown("Jump") && doubleJump == false)
			{
				doubleJump = true;
				movement.y = jumpSpeed;
			}
		}
		
        if(controller.isGrounded == true)
		{
			//reset the double jumo
			doubleJump = false;
			
			//Test to see if they are sprinting with the shift key
			if(Input.GetKey(KeyCode.LeftShift))
				movement.x = Input.GetAxis("Horizontal") * sprintSpeed;
			else
				//this was moved under the grounded state
				movement.x = Input.GetAxis("Horizontal") * speed;
			
			if (Input.GetButtonDown("Jump")) 
        		movement.y = jumpSpeed;
		}
            
        controller.Move(movement * Time.deltaTime);
    }
	
    void OnControllerColliderHit(ControllerColliderHit hit) {
        Rigidbody body = hit.collider.attachedRigidbody;
        if (body == null || body.isKinematic)
            return;
        
        if (hit.moveDirection.y < -0.3f)
            return;
        
        Vector3 pushDir = new Vector3(hit.moveDirection.x, 0f, 0f);
        body.velocity = pushDir * pushPower;
    }
}
