﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author
namespace SymulatorZielarza_WarstwaBazowa
{
    public interface IStanGry
    {
        // utworzenie nowej gry, skasowanie starego zapisu
        void UtworzNowaGre();

        //zaladowanie stanu zmiennych gry z trwalego zapisu
        void ZaladujGre();

        //zapisanie stanu zmiennych gry do trwalego zapisu
        void ZapiszGre();

        //pobranie zmiennej typu int o nazwie nazwaKlucza 
        int PobierzKluczInt(string nazwaKlucza);

        //pobranie zmiennej typu float o nazwie nazwaKlucza 
        float PobierzKluczFloat(string nazwaKlucza);

        //pobranie zmiennej typu string o nazwie nazwaKlucza 
        string PobierzKluczString(string nazwaKlucza);

        //zapisanie zmiennej zmienna pod nazwa nazwaKlucza
        void ZapiszKlucz(string nazwaKlucza, object zmienna);

        //usuniecie klucza o nazwie nazwaKlucza
        void UsunKlucz(string nazwaKlucza);

        //zwraca true jesli istnieje klucz o nazwie nazwaKlucza
        bool istniejeKlucz(string nazwaKlucza);

        //usuniecie wszystkich kluczy
        void WyczyscKlucze();

    }
}