﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System;
using System.Globalization;
using System.Xml.Linq;
using UnityEngine;

namespace ZielarzSilnik
{

    // struktura okreslajaca mozliwosc zajscia zdarzenia
    public class SzansaNaZdarzenie
    {
        public string TypZdarzeniaPoprzedniego;         //  jakie zdarzenie musialo wystepowac(null oznacza zdarzenie bez poprzednika)
        public string TypZdarzeniaNastepnego;           //  jakie zdarzenie zostanie wywolane
        public float Prawdopodobienstwo;                // szansa na wystapienie
        public CzescCiala LokalizacjaPoprzednia;        //  informacja gdzie zdarzenie poprzednie moglo wystepowac aby nastepne moglo zajsc
        public CzescCiala LokalizacjaNastepna;          // informacja gdzie zdarzenie nastepne moze wystapic, Dowolna oznacza lokalizacje dokladnie te sama co poprzednia
              
        //zaladuj dane szansy na zdarzenie z pojedynczego wezla XML 
        public void ZaladujDane(XElement elementXMLDanych)
        {
            if (elementXMLDanych.Attribute("poprzednie") == null || elementXMLDanych.Attribute("poprzednie").Value == "")
                TypZdarzeniaPoprzedniego = null;
            else
                TypZdarzeniaPoprzedniego = elementXMLDanych.Attribute("poprzednie").Value;
            if (elementXMLDanych.Attribute("nastepne") == null)
                Debug.LogError("Brak atrybutu nastepne w elemencie danych " + elementXMLDanych.ToString());
            else
                TypZdarzeniaNastepnego = elementXMLDanych.Attribute("nastepne").Value;
            if (elementXMLDanych.Attribute("prawd") == null)
                Debug.LogError("Brak atrybutu prawd w elemencie danych " + elementXMLDanych.ToString());
            else
                Prawdopodobienstwo = float.Parse(elementXMLDanych.Attribute("prawd").Value, CultureInfo.InvariantCulture);
            if (elementXMLDanych.Attribute("lokalizacjaPoprz") == null)
                Debug.LogError("Brak atrybutu lokalizacjaPoprz w elemencie danych " + elementXMLDanych.ToString());
            else
                LokalizacjaPoprzednia = (CzescCiala) Enum.Parse(typeof(CzescCiala), elementXMLDanych.Attribute("lokalizacjaPoprz").Value);
            if (elementXMLDanych.Attribute("lokalizacjaNast") == null || elementXMLDanych.Attribute("lokalizacjaNast").Value == "")
                LokalizacjaNastepna = CzescCiala.Dowolna;
            else
                LokalizacjaNastepna = (CzescCiala)Enum.Parse(typeof(CzescCiala), elementXMLDanych.Attribute("lokalizacjaNast").Value);
           
        }
    }

  
}