﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using UnityEngine;
using System.Collections.Generic;

namespace ZielarzSilnik.StanGry
{
    public abstract class MenedzerStanuGry : IStanGry
    { 
        protected Dictionary<string, string> _zmienne;
        public const string DOMYLNA_NAZWA_ZAPISU = "autozapis";
        public const string DOMYLNY_FOLDER_ZAPISU = "Zapis";
      
        // ***** konstruktor chroniony 
        protected MenedzerStanuGry()
        {
            _zmienne = new Dictionary<string, string>();
        }

        // ***** implementacja interfejsu IStanGry
        public void UtworzNowaGre()
    	{
            UsunPlik(DOMYLNA_NAZWA_ZAPISU);    	
    		_zmienne.Clear();
    	}
        public void ZaladujGre()
        {
            string zawartosc = ZaladujPliki(DOMYLNA_NAZWA_ZAPISU);
            KonwertujZawartoscDoZmiennych(zawartosc);
        }

        public void ZapiszGre()
        {
            ZapiszPliki(DOMYLNA_NAZWA_ZAPISU);
        }
        
        public int PobierzKluczInt(string nazwaKlucza)
        {
            if (_zmienne.ContainsKey(nazwaKlucza))
            {
                if (_zmienne[nazwaKlucza] == "")
                    return 0;
                try
                {
                    return int.Parse(_zmienne[nazwaKlucza]);
                }
                catch (System.Exception e)
                { Debug.LogError("Błąd konwersji: " + nazwaKlucza + ":" + _zmienne[nazwaKlucza]); }
            }
            return 0;
        }
        public float PobierzKluczFloat(string nazwaKlucza)
        {
            if (_zmienne.ContainsKey(nazwaKlucza))
            {
                if (_zmienne[nazwaKlucza] == "")
                    return 0f;
                try
                {
                    return float.Parse(_zmienne[nazwaKlucza], System.Globalization.CultureInfo.InvariantCulture);
                }
                catch (System.Exception e)
                { Debug.LogError("Błąd konwersji: " + nazwaKlucza + ":" + _zmienne[nazwaKlucza]); }
            }
            return 0f;
        }
        public string PobierzKluczString(string nazwaKlucza)
        {
            if (_zmienne.ContainsKey(nazwaKlucza))
            {
                return _zmienne[nazwaKlucza];
            }
            return "";
        }

        public void ZapiszKlucz(string nazwaKlucza, object zmienna)
        {
            if (!_zmienne.ContainsKey(nazwaKlucza))
                _zmienne.Add(nazwaKlucza, zmienna.ToString());
            else _zmienne[nazwaKlucza] = zmienna.ToString();
        }

        public void UsunKlucz(string nazwaKlucza)
        {
            if (_zmienne.ContainsKey(nazwaKlucza))
                _zmienne.Remove(nazwaKlucza);
        }

        public bool istniejeKlucz(string nazwaKlucza)
        {
            return  _zmienne.ContainsKey(nazwaKlucza);
        }

        // ***** prywatne i chronione metody wewnetrzne
        protected virtual string SciezkaZapisu()
        {
            return DOMYLNY_FOLDER_ZAPISU;
        }       
       
        private void KonwertujZawartoscDoZmiennych(string zawartosc)
        {
            _zmienne = new Dictionary<string, string>();
             string[] tokeny = zawartosc.Split('\n');
             for (int i = 0; i < tokeny.Length; i++)
             {
                 int pozycjaWartosci = tokeny[i].IndexOf("=");
                 if (pozycjaWartosci > 0)
                     ZapiszKlucz(tokeny[i].Substring(0, pozycjaWartosci), tokeny[i].Substring(pozycjaWartosci + 1));
            }
        }

        // ***** metody wewnetrzne implementowane w klasach wyprowadzonych
        protected abstract void UsunPlik(string nazwaPliku);
        protected abstract string ZaladujPliki(string nazwaPliku);
        protected abstract void ZapiszPliki(string nazwaPliku);
    
    }
}