﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System.Collections.Generic;
using System.Text;
using UnityEngine;

namespace ZielarzSilnik
{
    public class Gracz : Postac
    {
        private const float PODATEKDOCHODOWY = 0.18f;
        private const float KOSZTUTRZYMANIA = 50;

        private List< Receptura> _listaZnanychReceptur;
        public int LiczbaZnanychReceptur { get { return _listaZnanychReceptur.Count; } }
        private float _stanZlotaPoprzedniejDoby;
        //Gracz posiada atrybuty: Zloto oraz Reputacja. Do atrybutow moga nalezec znane receptury podane jako "Zna_X" gdzie X to nazwa receptury. Znajomosc okresla liczba wieksza niz 0. 
        public Gracz() : base()
        {
            _stanZlotaPoprzedniejDoby = 0;
            _atrybutyPostaci.Add("Zloto", 0);                 //złoto - waluta w grze
            _atrybutyPostaci.Add("Reputacja", 1);                //reputacja - określana na podstawie działań gracza, ma wpływ na dalszą grę
            _atrybutyPostaci.Add("Zna_RecepturaMagicznaMikstura", 1);    //taka recepture gracz zna juz na starcie gry

            _listaZnanychReceptur = new List<Receptura>();
          
        }
        public void Inicjuj()
        {
            SystemDniaNocyPogody.Instancja.ZmianaGodziny += UplynelaGodzina;
        }

        public Receptura PodajKolejnaRecepture(int indeks)
        {
            if (indeks >= 0 && indeks < LiczbaZnanychReceptur)
                return _listaZnanychReceptur[indeks];
            return null;

        }
        public void OdczytajGre()
        {
            _stanZlotaPoprzedniejDoby = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaFloat("zloto_poprzednio");
            UstawAtrybut("Zloto", MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaFloat("Zloto"));
            if (MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaFloat("Reputacja") > 0)
                UstawAtrybut("Reputacja", MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaFloat("Reputacja"));
            string recepturyStr = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaString("RecepturyGracza");
            string[] listaReceptur = recepturyStr.Split(';');
            foreach (string pojedynczaReceptura in listaReceptur)
                if(!_atrybutyPostaci.ContainsKey("Zna_" + pojedynczaReceptura))
                    _atrybutyPostaci.Add("Zna_" + pojedynczaReceptura, 1);
            OdswiezListeZnanychReceptur();
        }

        public void ZapiszGre()
        {
            MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("Zloto", PobierzAtrybut("Zloto"));
            MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("Reputacja", PobierzAtrybut("Reputacja"));
            string recepturyStr = "";
            foreach (Receptura pojedynczaReceptura in _listaZnanychReceptur)
                recepturyStr += "Zna_" + pojedynczaReceptura.Nazwa + ";";
            MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("RecepturyGracza", recepturyStr);
            MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("zloto_poprzednio", _stanZlotaPoprzedniejDoby);
        }
        //jeśli podany przedmiot jest recepturą to gracz pozna ją (na zawsze). A jeśli ją już znał - nic się nie zmieni.
        public void PoznajRecepture(Przedmiot przedmiot)
        {
            if(przedmiot.WewnetrznaReceptura != null )
            {
                UstawAtrybut("Zna_" + przedmiot.Nazwa, 1);
                OdswiezListeZnanychReceptur();
            }
        }

        private void OdswiezListeZnanychReceptur()
        {
            //kod bazuje na fakcie, że gracz nie może zapomnieć receptury - liczba znanych receptur tylko rośnie
            foreach (string kluczAtrybutu in _atrybutyPostaci.Keys)
                if (kluczAtrybutu.StartsWith("Zna_"))
                {
                    Receptura receptura = MenedzerZielarstwa.Instancja.ZnajdzRecepture(kluczAtrybutu.Replace("Zna_", ""));
                    if (receptura != null && !_listaZnanychReceptur.Contains(receptura))
                        _listaZnanychReceptur.Add(receptura);
                }
        }

        private void UplynelaGodzina(int godzina)
        {
            if (godzina == 0)
            {
                float zarobek = PobierzAtrybut("Zloto") - _stanZlotaPoprzedniejDoby;
                if (zarobek > 0)
                {
                    float podatek = zarobek * PODATEKDOCHODOWY;
                    if (podatek > 0)
                    {
                        UstawAtrybut("Zloto", PobierzAtrybut("Zloto") - (int)podatek);
                        MenedzerUI.Instancja.PokazMaleInfo(string.Format(TlumaczCiagow.PodajCiag("Podatek") , (int)podatek));
                    }
                }
                _stanZlotaPoprzedniejDoby = PobierzAtrybut("Zloto");
            }
            if (godzina == 6)
            {
                UstawAtrybut("Zloto", PobierzAtrybut("Zloto") - KOSZTUTRZYMANIA);
                MenedzerUI.Instancja.PokazMaleInfo(string.Format(TlumaczCiagow.PodajCiag("Utrzymanie"), KOSZTUTRZYMANIA));
            }
        }
    }


}
