﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System;
using System.Collections.Generic;
using UnityEngine;

namespace ZielarzSilnik
{
    [Flags]
    public enum CzescCiala
    {
        Glowa = 0,
        Oczy =  0x01,
        Uszy = 0x02,
        Nos = 0x04,
        Mozg = 0x08,
        JamaUstna = 0x10,
        Krtan = 0x20,
        Gardlo = 0x40,
        Tchawica = 0x80,
        Oskrzela = 0x100,
        Pluca = 0x200,
        Serce = 0x400,
        Ramiona = 0x800,
        Lokcie = 0x1000,
        Dlonie = 0x2000,
        Szyja = 0x4000,
        Zebra = 0x8000,
        Zoladek = 0x10000,
        Watroba = 0x20000,
        Trzustka = 0x40000,
        Pecherz = 0x80000,
        JelitoCienkie = 0x100000,
        JelitoGrube = 0x200000,
        NarzadyRozrodcze = 0x400000,
        Posladki = 0x800000,
        Uda = 0x1000000,
        Lydki = 0x2000000,
        Stopy = 0x4000000,
        Kostki = 0x8000000,
        Nerki = 0x10000000,
        Brzuch = 0x20000000,
        WieleNarzadow = 0x40000000,
        //zbiorcze
        GorneDrogiOddechowe = JamaUstna | Gardlo | Krtan | Tchawica,
        DolneDrogiOddechowe = Oskrzela | Pluca,
        DrogiOddechowe = GorneDrogiOddechowe | DolneDrogiOddechowe,
        Rece = Ramiona | Lokcie | Dlonie,
        Nogi = Uda | Lydki | Kostki | Stopy,
        Tulow = Brzuch | Zebra,
        UkladTrawienny = Zoladek | JelitoCienkie | JelitoGrube | Watroba | Trzustka,
        UkladMoczowy = Pecherz | Nerki,
        Zewnetrzne = Glowa | Rece | Tulow | Nogi | Uszy | Nos |Szyja | Posladki,
        Wewnetrzne = DrogiOddechowe | UkladTrawienny | UkladMoczowy | NarzadyRozrodcze | Serce | Oczy | Mozg | Zebra,
        //wszystko
        Dowolna = Zewnetrzne | Wewnetrzne | WieleNarzadow
     
    };

    public class MechanikaCzesciCiala
    {
        public static float MnoznikCzesciCiala(CzescCiala czesc)
        {
            switch (czesc)
            {
                case CzescCiala.Glowa: return 0.35f;
                case CzescCiala.Oczy: return 0.25f;
                case CzescCiala.Mozg: return 1f;
                case CzescCiala.Tchawica: return 0.15f;
                case CzescCiala.Oskrzela: return 0.25f;
                case CzescCiala.Pluca: return 0.45f;
                case CzescCiala.Serce: return 1f;
                case CzescCiala.Szyja: return 0.2f;
                case CzescCiala.Zoladek: return 0.25f;
                case CzescCiala.Watroba: return 0.4f;
                case CzescCiala.Trzustka: return 0.3f;
                case CzescCiala.Pecherz: return 0.2f;
                case CzescCiala.JelitoCienkie: return 0.2f;
                case CzescCiala.JelitoGrube: return 0.2f;
                case CzescCiala.Nerki: return 0.35f;
                case CzescCiala.Brzuch: return 0.15f;
                case CzescCiala.WieleNarzadow: return 1f;
                case CzescCiala.GorneDrogiOddechowe: return 0.4f;
                case CzescCiala.DolneDrogiOddechowe: return 0.6f;
                case CzescCiala.DrogiOddechowe: return 0.8f;
                case CzescCiala.Rece: return 0.3f;
                case CzescCiala.Nogi: return 0.3f;
                case CzescCiala.Tulow: return 0.2f;
                case CzescCiala.UkladTrawienny: return 0.5f;
                case CzescCiala.UkladMoczowy: return 0.5f;
                case CzescCiala.Zewnetrzne: return 0.6f;
                case CzescCiala.Wewnetrzne: return 0.9f;
                case CzescCiala.Dowolna: return 1f;
            }
            return 0.1f;
        }
        public static float MinimalnaSilaCzesciCiala(CzescCiala czesc)
        {
            switch (czesc)
            {
                case CzescCiala.Glowa: return 0.15f;
                case CzescCiala.Oczy: return 0.1f;
                case CzescCiala.Mozg: return 0.5f;
                case CzescCiala.Oskrzela: return 0.1f;
                case CzescCiala.Pluca: return 0.25f;
                case CzescCiala.Serce: return 0.5f;
                case CzescCiala.Zoladek: return 0.1f;
                case CzescCiala.Watroba: return 0.15f;
                case CzescCiala.Trzustka: return 0.1f;
                case CzescCiala.Pecherz: return 0.1f;
                case CzescCiala.JelitoCienkie: return 0.1f;
                case CzescCiala.JelitoGrube: return 0.1f;
                case CzescCiala.Nerki: return 0.2f;
                case CzescCiala.WieleNarzadow: return 0.35f;
                case CzescCiala.DolneDrogiOddechowe: return 0.15f;
                case CzescCiala.UkladTrawienny: return 0.1f;
                case CzescCiala.UkladMoczowy: return 0.1f;
            }
            return 0f;
        }
        public static float MaksymalnaSilaCzesciCiala(CzescCiala czesc)
        {
            switch (czesc)
            {
                case CzescCiala.Tchawica: return 0.8f;
                case CzescCiala.Oskrzela: return 0.9f;
                case CzescCiala.Brzuch: return 0.9f;
                case CzescCiala.GorneDrogiOddechowe: return 0.9f;
                case CzescCiala.Rece: return 0.8f;
                case CzescCiala.Nogi: return 0.9f;
                case CzescCiala.Tulow: return 0.9f;
            }
            return 1f;
        }
        public static Vector2[] PodajPunktyNaMapce(CzescCiala czesc)
        {
            Vector2[] lista;
            switch (czesc)
            {

                case CzescCiala.Glowa: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.083f } }; break;
                case CzescCiala.Oczy: lista = new Vector2[] { new Vector2 { x = 0.48f, y = 0.1125f }, new Vector2 { x = 0.536f, y = 0.1125f } }; break;
                case CzescCiala.Uszy: lista = new Vector2[] { new Vector2 { x = 0.406f, y = 0.119f }, new Vector2 { x = 0.612f, y = 0.119f } }; break;
                case CzescCiala.Nos: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.0958f } }; break;
                case CzescCiala.JamaUstna: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.149f } }; break;
                case CzescCiala.Mozg: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.1325f } }; break;
                case CzescCiala.Krtan: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.165f } }; break;
                case CzescCiala.Gardlo: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.15f } }; break;
                case CzescCiala.Tchawica: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.18f } }; break;
                case CzescCiala.Oskrzela: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.213f } }; break;
                case CzescCiala.Pluca: lista = new Vector2[] { new Vector2 { x = 0.404f, y = 0.258f }, new Vector2 { x = 0.616f, y = 0.258f } }; break;
                case CzescCiala.Serce: lista = new Vector2[] { new Vector2 { x = 0.612f, y = 0.2758f } }; break;
                case CzescCiala.Ramiona: lista = new Vector2[] { new Vector2 { x = 0.276f, y = 0.2625f }, new Vector2 { x = 0.748f, y = 0.2625f } }; break;
                case CzescCiala.Lokcie: lista = new Vector2[] { new Vector2 { x = 0.208f, y = 0.4f }, new Vector2 { x = 0.816f, y = 0.4f } }; break;
                case CzescCiala.Dlonie: lista = new Vector2[] { new Vector2 { x = 0.17f, y = 0.5416f }, new Vector2 { x = 0.866f, y = 0.5416f } }; break;
                case CzescCiala.Szyja: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.1625f } }; break;
                case CzescCiala.Zebra: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.267f } }; break;
                case CzescCiala.Zoladek: lista = new Vector2[] { new Vector2 { x = 0.638f, y = 0.3375f } }; break;
                case CzescCiala.Watroba: lista = new Vector2[] { new Vector2 { x = 0.432f, y = 0.325f } }; break;
                case CzescCiala.Trzustka: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.35f } }; break;
                case CzescCiala.Pecherz: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.484f } }; break;
                case CzescCiala.JelitoCienkie: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.433f } }; break;
                case CzescCiala.JelitoGrube: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.471f } }; break;
                case CzescCiala.NarzadyRozrodcze: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.52f } }; break;
                case CzescCiala.Posladki: lista = new Vector2[] { new Vector2 { x = 0.406f, y = 0.52f }, new Vector2 { x = 0.62f, y = 0.52f } }; break;
                case CzescCiala.Uda: lista = new Vector2[] { new Vector2 { x = 0.372f, y = 0.61f }, new Vector2 { x = 0.652f, y = 0.61f } }; break;
                case CzescCiala.Lydki: lista = new Vector2[] { new Vector2 { x = 0.29f, y = 0.8025f }, new Vector2 { x = 0.734f, y = 0.8025f } }; break;
                case CzescCiala.Stopy: lista = new Vector2[] { new Vector2 { x = 0.268f, y = 0.935f }, new Vector2 { x = 0.755f, y =0.935f } }; break;
                case CzescCiala.Kostki: lista = new Vector2[] { new Vector2 { x = 0.282f, y = 0.893f }, new Vector2 { x = 0.74f, y = 0.893f } }; break;
                case CzescCiala.Nerki: lista = new Vector2[] { new Vector2 { x = 0.43f, y = 0.4292f }, new Vector2 { x = 0.59f, y = 0.4292f } }; break;
                case CzescCiala.Brzuch: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.3875f } }; break;
                case CzescCiala.WieleNarzadow: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.1033f }, new Vector2 { x = 0.51f, y = 0.297f }, new Vector2 { x = 0.51f, y = 0.4567f }, new Vector2 { x = 0.66f, y = 0.3258f } }; break;
                case CzescCiala.GorneDrogiOddechowe: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.164f } }; break;
                case CzescCiala.DolneDrogiOddechowe: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.2458f } }; break;
                case CzescCiala.DrogiOddechowe: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.204f } }; break;
                case CzescCiala.Rece: lista = new Vector2[] { new Vector2 { x = 0.208f, y = 0.4f }, new Vector2 { x = 0.816f, y = 0.4f } }; break;
                case CzescCiala.Nogi: lista = new Vector2[] { new Vector2 { x = 0.366f, y = 0.6741f }, new Vector2 { x = 0.66f, y = 0.6741f } }; break;
                case CzescCiala.Tulow: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.335f } }; break;
                case CzescCiala.UkladTrawienny: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.4075f } }; break;
                case CzescCiala.UkladMoczowy: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.458f } }; break;
                case CzescCiala.Zewnetrzne: lista = new Vector2[] { new Vector2 { x = 0.198f, y = 0.2958f }, new Vector2 { x = 0.832f, y = 0.2958f }, new Vector2 { x = 0.292f, y = 0.674f }, new Vector2 { x = 0.74f, y = 0.674f } }; break;
                case CzescCiala.Wewnetrzne: lista = new Vector2[] { new Vector2 { x = 0.51f, y = 0.2958f }, new Vector2 { x = 0.51f, y = 0.419f } }; break;
                //PG   -11.23 6
                //LD   -6.23 -6
                //WIDTH = 5  HEIGHT = 12
                default: lista = new Vector2[] { }; break;

            }
            for (int i = 0; i < lista.Length; i++)
            {
                lista[i].x = lista[i].x * 5 - 11.23f;
                lista[i].y = 6 - 12 * lista[i].y;
            }
            return lista;
        }
    }

     
}