﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System.Globalization;
using System.Xml.Linq;
using UnityEngine;

namespace ZielarzSilnik
{
    //wplyw zdarzenia na parametr ogolny postaci
    public class WplywNaParametr
    {
        public string Parametr;     //id parametru (np. "health" - zdrowie ogolne)
        public float Wartosc;       //wartosc bedaca srednia zmiana parametru na godzine

        //zaladuj dane  z pojedynczego wezla XML zdarzen
        public WplywNaParametr(XElement elementXMLDanych)
        {
            if (elementXMLDanych.Attribute("param") == null)
                Debug.LogError("Brak atrybutu param w elemencie danych " + elementXMLDanych.ToString());
            else Parametr = elementXMLDanych.Attribute("param").Value;
            if (elementXMLDanych.Attribute("wart") == null)
                Debug.LogError("Brak atrybutu wart w elemencie danych " + elementXMLDanych.ToString());
            else
                Wartosc = float.Parse(elementXMLDanych.Attribute("wart").Value, CultureInfo.InvariantCulture);
        }

        public WplywNaParametr(WplywNaParametr klonujZTego)
        {
            Parametr = klonujZTego.Parametr;
            Wartosc = klonujZTego.Wartosc;
        }
    }
}