﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace ZielarzSilnik
{
    public class Plecak : MonoBehaviour
    {
        public float SKALAPLECAKA = 5;           //skalowanie duszka przedmiotu w plecaku
        public const int LICZBAPANELIPLECAKA = 8;   //maks. liczba paneli przedmiotow na ekranie
        public const int ROZMIARDUSZKAPLECAKA = 512;  //rozmiar duszka panelu przedmiotu
        public GameObject WzorzecPaneluPlecaka;   //wzorzec do generowania panelów przedmiotów
        public GameObject ZnacznikAktywnejRamki;   //obiekt ktorym bedziemy zaznaczac aktywna ramke
        public Text  NazwaAktywnegoPrzedmiotu, OpisAktywnegoPrzedmiotu;   // tekst mówiący o tym jak nazywa się aktywnie wybrany przedmiot
        public Canvas KanwaOpisuAktywnegoPrzedmiotu;
        private bool _rozszerzony;

        //informuje i ustawia plecak rozszerzony do wszystkich przedmiotow
        public bool Rozszerzony
        {
            get {
                return  _rozszerzony; 
            }
            set
            {               
                _rozszerzony = value;
                OdswiezWszystko();
            }
        }
        //przedmiot na pozycji pozycja, null oznacza brak przedmiotu w plecaku na tej pozycji
        public Przedmiot this[int pozycja]
        {
            get
            {
                if (pozycja >= 0 && pozycja < _przedmioty.Count)
                    return _przedmioty[pozycja];
                else
                    return null;
            }
        }
        private void DodajWewnetrzniePrzedmiot(Przedmiot nowyPrzedmiot)
        {
            _przedmioty.Add(nowyPrzedmiot);
        }
        //przedmiot na aktywnej pozycji pozycja, null oznacza brak przedmiotu na aktywnej pozycji
        public Przedmiot AktywnyPrzedmiot
        {
            get
            {
                return this[_wybranyPrzedmiot];
            }
        }

        private List<Przedmiot> _przedmioty;
        private GameObject[] _panelePlecaka;
        private int _wybranyPrzedmiot;

        public void OdczytajGre()
        {
            int liczbaPrzedmiotow = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaInt("plecak_liczba");
            for (int i = 0; i < liczbaPrzedmiotow; i++)
            {
                string przedmiotI = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaString("plecak_" + i);
                if (przedmiotI != null && przedmiotI != "")
                {
                    GameObject nowyPrzedmiot = PulaAktywnychPrzedmiotow.Instancja.PodajObiekt( przedmiotI);
                    if (nowyPrzedmiot.GetComponent<Przedmiot>() == null)
                        Debug.LogError("Błędny przedmiot w plecaku: " + przedmiotI);
                    else
                    {
                        nowyPrzedmiot.GetComponent<Przedmiot>().PrzygotujNaPlecak();
                        Dodaj(nowyPrzedmiot.GetComponent<Przedmiot>());
                    }
                }
            }
        }
        public void ZapiszGre()
        {
            for (int i = 0; i < _przedmioty.Count; i++)
                MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("plecak_" + i, _przedmioty[i].name);
            MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("plecak_liczba", _przedmioty.Count);
        }

        //Dodaje przedmiot do plecaka na pierwsze wolne miejsce albo na miejsce _wybranyPanel jesli brak wolnych miejsc
        public void Dodaj(Przedmiot dodawanyPrzedmiot)
        {
            DodajWewnetrzniePrzedmiot(dodawanyPrzedmiot);
            dodawanyPrzedmiot.transform.parent = transform;
            dodawanyPrzedmiot.transform.localScale = dodawanyPrzedmiot.transform.localScale / SKALAPLECAKA;
            dodawanyPrzedmiot.transform.localRotation = Quaternion.Euler(dodawanyPrzedmiot.RotacjaWPlecaku);
            OdswiezPozycjePrzedmiotow();
            MenedzerAktywnychPrzedmiotow.Instancja.UsunAktywnyPrzedmiot(dodawanyPrzedmiot.GetComponent<AktywnyObiekt>());
            OdswiezWszystko();
        }
        //usuwa aktualnie wybrany przedmiot wyrzucajac go na ziemie
        public void UsunAktywnyPrzedmiot()
        {
            if(AktywnyPrzedmiot != null)
            {
                PrzedmiotZostalUsuniety(AktywnyPrzedmiot);
                if (_przedmioty.Contains(AktywnyPrzedmiot))
                    _przedmioty.Remove(AktywnyPrzedmiot);
                if (_wybranyPrzedmiot >= _przedmioty.Count)
                    _wybranyPrzedmiot = 0;
                OdswiezWszystko();
            }
        }
        //przesuwa wybrany panel o przesuniecie (1 w prawo -1 w lewo)
        public void PrzesunWybranyPrzedmiot(int przesuniecie)
        {
            _wybranyPrzedmiot -= przesuniecie;
            if (_wybranyPrzedmiot < 0)
                _wybranyPrzedmiot = _przedmioty.Count - 1;
            if (_wybranyPrzedmiot >= _przedmioty.Count)
                _wybranyPrzedmiot = 0;
            OdswiezWszystko();
        }
        //usuwa przedmiot z plecaka nie wyrzucajac go na ziemie (zniszczony, przekazany komus itp.)
        public void ZniszczPoCichuPrzedmiot(Przedmiot ktoryPrzedmiot)
        {
            if (_przedmioty.Contains(ktoryPrzedmiot))
            {
                _przedmioty.Remove(ktoryPrzedmiot);
                if (_wybranyPrzedmiot >= _przedmioty.Count)
                    _wybranyPrzedmiot = 0;
                ktoryPrzedmiot.transform.localScale = ktoryPrzedmiot.transform.localScale * SKALAPLECAKA;
                ktoryPrzedmiot.UsunZPlecaka();
                PulaAktywnychPrzedmiotow.Instancja.ZwolnijObiekt(ktoryPrzedmiot.gameObject);
                OdswiezWszystko();
            }
        }
        //zwraca true jesli plecak posiada przedmiot o podanej nazwie, lub false jesli nie
        public bool CzyPosiadaPrzedmiot(string nazwaPrzedmiotu)
        {
            foreach (Przedmiot p in _przedmioty)
                if (p != null && p.GetComponent<AktywnyObiekt>().Nazwa == nazwaPrzedmiotu)
                    return true;
            return false;
        }
        //zwraca przedmiot z plecaka szukajac go po nazwie albo null jesli przedmiotu o podadnej nazwie nie ma w plecaku
        public Przedmiot ZnajdzPrzedmiot(string nazwaPrzedmiotu)
        {
            foreach (Przedmiot p in _przedmioty)
                if (p != null && p.GetComponent<AktywnyObiekt>().Nazwa == nazwaPrzedmiotu)
                    return p;
            return null;
        }
        //zwraca informacje czy jest w plecaku miejsce na przedmiot
        public bool CzyMoznaDodacPrzedmiot(Przedmiot przedmiot)
        {            
            return true;
        }
        //zwraca liste przedmiotow o liczebnosci iloscPrzedmiotow poczawszy od wybranego przedmiotu
        public List<Przedmiot> PodajListePrzedmiotow(int iloscPrzedmiotow)
        {
            List<Przedmiot> zwracane = new List<Przedmiot>();
            if (_przedmioty.Count <= iloscPrzedmiotow)
                zwracane.AddRange(_przedmioty);
            else
            {
                int indeks = _wybranyPrzedmiot;
                while (zwracane.Count < iloscPrzedmiotow)
                {
                    zwracane.Add(this[indeks]);
                    if (++indeks >= _przedmioty.Count)
                        indeks = 0;
                }
            }
            return zwracane;
        }
        private void Awake()
        {
            _przedmioty = new List<Przedmiot>();
            _panelePlecaka = new GameObject[LICZBAPANELIPLECAKA];
            if (ZnacznikAktywnejRamki == null)
                Debug.Log("Nieustaiono znacznika aktywnego panelu");
            if (WzorzecPaneluPlecaka == null)
                Debug.Log("Nieustaiono wzorca panelu plecaka");
            else
                GenerujPaneleUI();
            Rozszerzony = false;
            _wybranyPrzedmiot = 0;
        }
        bool _pierszyUpdate;
        private void Start()
        {
            _pierszyUpdate = true;
        }
        private void Update()
        {
            if(_pierszyUpdate)
            {
                //Odświeżenie w tym miejscu ustawia odpowiednie pozycje przedmiotów. Jest to niezbędne bo dopiero w pierwszej klatce po odczycie stanu gry (robionym w metodzie Start) przedmioty będą mieć poprawnie zainicjalizowane m.in. skale
                OdswiezWszystko();
                _pierszyUpdate = false;
            }
        }
        private void GenerujPaneleUI()
        {
            if (_panelePlecaka != null)
                foreach (GameObject panel in _panelePlecaka)
                    Destroy(panel);
            _panelePlecaka = new GameObject[LICZBAPANELIPLECAKA];
            for (int i = 0; i < LICZBAPANELIPLECAKA; i++)
            {
                _panelePlecaka[i] = Instantiate(WzorzecPaneluPlecaka, transform);
                _panelePlecaka[i].transform.localPosition = new Vector3(0f, 0f, 0f);
                _panelePlecaka[i].transform.localRotation = Quaternion.identity;
                _panelePlecaka[i].SetActive(true);
            }
            WzorzecPaneluPlecaka.SetActive(false);
        }
        private void OdswiezWszystko()
        {
            OdswiezPozycjePaneliUI();
            OdswiezPozycjePrzedmiotow();
            OdswiezInformacjeOAktywnymPrzedmiocie();
        }
        private void OdswiezPozycjePaneliUI()
        {
            if (_panelePlecaka == null)
                GenerujPaneleUI();
            float rozmiarPanelu = (ROZMIARDUSZKAPLECAKA / 128f) * WzorzecPaneluPlecaka.transform.localScale.x;
            for (int i = 0; i < LICZBAPANELIPLECAKA; i++)
            {
                _panelePlecaka[i].SetActive(Rozszerzony | i == 0);
                if (Rozszerzony)
                    _panelePlecaka[i].transform.localPosition = WzorzecPaneluPlecaka.transform.localPosition + new Vector3(rozmiarPanelu * 0.5f + i * (rozmiarPanelu + 0.01f), rozmiarPanelu * 0.5f, 0);
                else
                    _panelePlecaka[i].transform.localPosition = WzorzecPaneluPlecaka.transform.localPosition + new Vector3(rozmiarPanelu * 0.5f, rozmiarPanelu * 0.5f, 0);
            }
            ZnacznikAktywnejRamki.SetActive(Rozszerzony);
            ZnacznikAktywnejRamki.transform.localPosition = _panelePlecaka[0].transform.localPosition;
            NazwaAktywnegoPrzedmiotu.transform.localPosition = WzorzecPaneluPlecaka.transform.localPosition + new Vector3(0, 2 * rozmiarPanelu, 0);            
            OpisAktywnegoPrzedmiotu.transform.localPosition = WzorzecPaneluPlecaka.transform.localPosition + new Vector3(0, 1.68f * rozmiarPanelu, 0);
        }

        private void OdswiezPozycjePrzedmiotow()
        {
            for (int i = 0; i < _przedmioty.Count; i++)
                this[i].gameObject.SetActive(false);
            int ktoryPrzedmiot = _wybranyPrzedmiot;
            bool stop = false;
            for (int i = 0; i < LICZBAPANELIPLECAKA && !stop; i++)
            {
                if (this[ktoryPrzedmiot] != null)
                {
                    this[ktoryPrzedmiot].gameObject.SetActive(Rozszerzony || ktoryPrzedmiot == _wybranyPrzedmiot);
                    this[ktoryPrzedmiot].transform.localPosition = _panelePlecaka[i].transform.localPosition + this[ktoryPrzedmiot].PrzesuniecieWPlecaku;
                    if (++ktoryPrzedmiot >= _przedmioty.Count)
                        ktoryPrzedmiot = 0;
                }
                if (this[ktoryPrzedmiot] == null)
                    ktoryPrzedmiot = 0;
                if (ktoryPrzedmiot == _wybranyPrzedmiot)
                    stop = true;
            }

        }
        private void OdswiezInformacjeOAktywnymPrzedmiocie()
        {
            if(Rozszerzony && this[_wybranyPrzedmiot] != null)
            {
                NazwaAktywnegoPrzedmiotu.text = this[_wybranyPrzedmiot].CzytelnaNazwa ;
                OpisAktywnegoPrzedmiotu.text =  this[_wybranyPrzedmiot].Opis;
                NazwaAktywnegoPrzedmiotu.gameObject.SetActive(true);
                OpisAktywnegoPrzedmiotu.gameObject.SetActive(true);
            }
            else
            {
                NazwaAktywnegoPrzedmiotu.gameObject.SetActive(false);
                OpisAktywnegoPrzedmiotu.gameObject.SetActive(false);
            }
        }
        private void PrzedmiotZostalUsuniety(Przedmiot usuniety)
        {
            usuniety.transform.localScale = usuniety.transform.localScale * SKALAPLECAKA;
            usuniety.UsunZPlecaka();
            MenedzerAktywnychPrzedmiotow.Instancja.DodajAktywnyPrzedmiot(usuniety.GetComponent<AktywnyObiekt>());
        }

       
    }
}
