﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEngine;
using UnityEngine.UI;

namespace ZielarzSilnik
{
    public class UIStatystyk : MonoBehaviour
    {
        public Text TekstStatystyka;
        public Canvas Kanwa;
        private float _licznikSekund;
        private const float CZESTOTLIWOSCSPRAWDZANODLEGLOSCI = 0.5f;
        private void Start()
        {
            if (TekstStatystyka == null)
                Debug.LogError("Nie ustawiono pola TekstStatystyka");
            if (Kanwa == null)
                Debug.LogError("Nie ustawiono pola Kanwa");
            Kanwa.gameObject.SetActive(false);
            _licznikSekund = 0;
        }
        public void Uaktywnij()
        {
            Kanwa.gameObject.SetActive(true);
            int zmarlo = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaInt("Zmarli");
            int wyzdrowialo = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaInt("Wyzdrowieli");
            TekstStatystyka.text = string.Format(TlumaczCiagow.PodajCiag("Statystyka"), SystemDniaNocyPogody.Instancja.DzienGry, wyzdrowialo, zmarlo);

            _licznikSekund = 1;
        }
        void Update()
        {
            if (Kanwa.gameObject.activeInHierarchy)
            {
                _licznikSekund -= Time.deltaTime;
                if (_licznikSekund < 0)
                {
                    _licznikSekund = CZESTOTLIWOSCSPRAWDZANODLEGLOSCI;
                    if ((MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.position - transform.position).magnitude > MenedzerUI.DYSTANSPOKAZYWANIAKANWY)
                    {
                        Kanwa.gameObject.SetActive(false);
                    }
                }
            }
        }
    }

}
