﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using SymulatorZielarza_WarstwaBazowa;
using UnityEngine;
using UnityEngine.UI;

namespace ZielarzSilnik
{
    public class UIRzemieslnictwa : MonoBehaviour
    {       
        public Text[] ListaRecepturTeksty;
        public Text TekstOpisu, TekstNazwy, TekstInformacyjny, PrzyciskStworz, TekstTytulowy;
        public Image StrzalkaGora, StrzalkaDol;
        public Image[] PolaPrzedmiotow;

        private int _indeksPierwszejReceptury;
        private Receptura[] _listaReceptur;
        private GameObject[] _obiektySkladnikow;
        private Receptura _wybranaReceptura;
        private float _licznikSekund;
        private const float CZESTOTLIWOSCSPRAWDZANODLEGLOSCI = 0.5f;
        private IMenedzerWejscia _menedzerWejscia;

        //akcja po kliknięciu w przycisk z nazwą receptury - uaktywnia pola szczegółów receptury i możliwość jej wykonania jeśli gracz posiada komplet składników
        public void KlikniecieWPrzyciskReceptury(int ktoryPrzycisk)
        {
            if (_listaReceptur[ktoryPrzycisk] != null)
            {
                ZwolnijListeSkladnikow();
                _wybranaReceptura = _listaReceptur[ktoryPrzycisk];
                TekstNazwy.text = TlumaczCiagow.PodajCiag("Przedmiot" + _wybranaReceptura.Nazwa);
                TekstOpisu.text = TlumaczCiagow.PodajCiag("Opis" + _wybranaReceptura.Nazwa );
                TekstInformacyjny.text = TlumaczCiagow.PodajCiag("Skladniki");
                _obiektySkladnikow = ZbudujListeSkladnikow(_listaReceptur[ktoryPrzycisk]);
                int indeksPolaPrzedmiotu = 0;
                bool pelnySklad = true;
                for(int i = 0; i < _obiektySkladnikow.Length && indeksPolaPrzedmiotu < PolaPrzedmiotow.Length; i++)
                {
                    PolaPrzedmiotow[indeksPolaPrzedmiotu].gameObject.SetActive(true);
                    PolaPrzedmiotow[indeksPolaPrzedmiotu].transform.GetComponentInChildren<Text>().text = TlumaczCiagow.PodajCiag("Przedmiot" + _wybranaReceptura.Skladniki[i]);
                    if (_obiektySkladnikow[i] != null)
                    {
                        _obiektySkladnikow[i].GetComponent<Przedmiot>().PrzygotujNaPlecak();
                        _obiektySkladnikow[i].transform.parent = PolaPrzedmiotow[indeksPolaPrzedmiotu].transform;
                        _obiektySkladnikow[i].transform.localPosition = Vector3.zero + _obiektySkladnikow[i].GetComponent<Przedmiot>().PrzesuniecieWPlecaku * 20;
                        _obiektySkladnikow[i].transform.localRotation = Quaternion.Euler(_obiektySkladnikow[i].GetComponent<Przedmiot>().RotacjaWPlecaku);
                    }
                    else pelnySklad = false;
                    indeksPolaPrzedmiotu++;
                }
                for (;  indeksPolaPrzedmiotu < PolaPrzedmiotow.Length; indeksPolaPrzedmiotu++)
                    PolaPrzedmiotow[indeksPolaPrzedmiotu].gameObject.SetActive(false);
                PrzyciskStworz.gameObject.SetActive(pelnySklad);
                PrzyciskStworz.text = TlumaczCiagow.PodajCiag("Utworz") + " " + TlumaczCiagow.PodajCiag("Przedmiot" + _wybranaReceptura.Rezultat);
            }
        }
        //akcja po kliknięciu przycisku przewijania receptur w górę
        public void KlikniecieStrzalkaGora()
        {
            if (_indeksPierwszejReceptury > 0)
            {
                _indeksPierwszejReceptury--;
                OdswiezInformacje();
            }
        }
        //akcja po kliknięciu przycisku przewijania receptur w dół
        public void KlikniecieStrzalkaDol()
        {
            if (_indeksPierwszejReceptury + _listaReceptur.Length < MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.LiczbaZnanychReceptur)
            {
                _indeksPierwszejReceptury++;
                OdswiezInformacje();
            }
        }
        //akcja po kliknięciu przycisku tworzenia przedmiotu z receptury
        public void KlikniecieStworz()
        {
            if(_obiektySkladnikow != null && _wybranaReceptura != null)
            {
                bool pelnySklad = true;
                for (int i = 0; i < _obiektySkladnikow.Length; i++)
                    if (_obiektySkladnikow[i] == null)
                        pelnySklad = false;
                if(pelnySklad)
                {
                    //zużycie składników z plecaka
                    for (int i = 0; i < _obiektySkladnikow.Length; i++)
                    {
                        Przedmiot skladnikWPlecaku = MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.ZnajdzPrzedmiot(_obiektySkladnikow[i].GetComponent<AktywnyObiekt>().Nazwa);
                        MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.ZniszczPoCichuPrzedmiot(skladnikWPlecaku);
                    }
                    //utworzenie rezultatu i dodanie go do plecaka (miejsce musi być bo usuwamy z niego składniki)
                    GameObject rezultatObiekt = PulaAktywnychPrzedmiotow.Instancja.PodajObiekt( _wybranaReceptura.Rezultat);
                    rezultatObiekt.GetComponent<Przedmiot>().PrzygotujNaPlecak();
                    MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.Dodaj(rezultatObiekt.GetComponent<Przedmiot>());
                    MenedzerUI.Instancja.PokazMaleInfo(TlumaczCiagow.PodajCiag("RzemieslnictwoSukces") + rezultatObiekt.GetComponent<Przedmiot>().CzytelnaNazwa);
                }
                OdswiezInformacje();
            }
        }

        private void Awake()
        {
            _menedzerWejscia = MenedzerGry.InstancjaMenedzeraGry.ObiektSelektoraPlatformy.UtworzMenedzerWejscia();
            gameObject.SetActive(false);
        }
        private void Start()
        {
            if (ListaRecepturTeksty.Length == 0)
                Debug.LogError("Nie ustawiono pola ListaRecepturTeksty");
            if (TekstOpisu == null)
                Debug.LogError("Nie ustawiono pola TekstOpisu");
            if (TekstNazwy == null)
                Debug.LogError("Nie ustawiono pola TekstNazwy");
            if (StrzalkaGora == null)
                Debug.LogError("Nie ustawiono pola StrzalkaGora");
            if (StrzalkaDol == null)
                Debug.LogError("Nie ustawiono pola StrzalkaDol");
            if (TekstInformacyjny == null)
                Debug.LogError("Nie ustawiono pola TekstInformacyjny");
            if (TekstTytulowy == null)
                Debug.LogError("Nie ustawiono pola TekstTytulowy");
            if (PrzyciskStworz == null)
                Debug.LogError("Nie ustawiono pola PrzyciskStworz");
            if (PolaPrzedmiotow.Length == 0)
                Debug.LogError("Nie ustawiono pola PolaPrzedmiotow");
            TekstTytulowy.text = TlumaczCiagow.PodajCiag("Rzemieslnictwo");
            _licznikSekund = 0;
        }
        private void OnEnable()
        {
            _menedzerWejscia.NasluchujWejscie(WykonajLogicznaAkcje);
            _indeksPierwszejReceptury = 0;
            _licznikSekund = 1;
            ZwolnijListeSkladnikow();
            OdswiezInformacje();
        }
        private void OnDisable()
        {
            _menedzerWejscia.ZakonczNasluch(WykonajLogicznaAkcje);
        }

        public void WykonajLogicznaAkcje(LogicznaAkcja akcja)
        {
            if (akcja == LogicznaAkcja.WyrzucPrzedmiot)
                gameObject.SetActive(false);
        }

        private void OdswiezInformacje()
        {
            TekstNazwy.text = "";
            TekstOpisu.text = "";
            TekstInformacyjny.text = "";
            _wybranaReceptura = null;
           _listaReceptur = new Receptura[ListaRecepturTeksty.Length];
            int indeksTekstu = 0;
            for (int i = _indeksPierwszejReceptury; i < MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.LiczbaZnanychReceptur && indeksTekstu < ListaRecepturTeksty.Length; i++)
            {
                ListaRecepturTeksty[indeksTekstu].gameObject.SetActive(true);
                ListaRecepturTeksty[indeksTekstu].text = TlumaczCiagow.PodajCiag("Przedmiot" + MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PodajKolejnaRecepture(i).Nazwa);
                _listaReceptur[indeksTekstu] = MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PodajKolejnaRecepture(i);
                indeksTekstu++;
            }
            for (; indeksTekstu < ListaRecepturTeksty.Length; indeksTekstu++)
            {
                ListaRecepturTeksty[indeksTekstu].gameObject.SetActive(false);
                _listaReceptur[indeksTekstu] = null;
            }
            StrzalkaGora.gameObject.SetActive(_indeksPierwszejReceptury > 0);
            StrzalkaDol.gameObject.SetActive(_indeksPierwszejReceptury  + _listaReceptur.Length < MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.LiczbaZnanychReceptur);
            PrzyciskStworz.gameObject.SetActive(false);
            foreach (Image obr in PolaPrzedmiotow)
                obr.gameObject.SetActive(false);
        }

        //tworzy i zwraca liste skladnikow dla podanej receptury, przy czym lista zawiera pozycje o wartosciach null dla skladnikow ktorych nie ma w plecaku gracza
        private GameObject[] ZbudujListeSkladnikow(Receptura receptura)
        {
            GameObject[] zwracanaLista = new GameObject[receptura.Skladniki.Count];
            for(int i = 0; i < receptura.Skladniki.Count; i++)
            {
                if (MenedzerGry.InstancjaMenedzeraGry.ObiektPlecaka.CzyPosiadaPrzedmiot(receptura.Skladniki[i]))
                    zwracanaLista[i] = PulaAktywnychPrzedmiotow.Instancja.PodajObiekt( receptura.Skladniki[i]);
                else
                    zwracanaLista[i] = null;
            }
            return zwracanaLista;
        }
        //zwalnia wczesniej pobrane z puli przedmioty receptury
        private void ZwolnijListeSkladnikow()
        {
            if (_obiektySkladnikow != null)
                for (int i = 0; i < _obiektySkladnikow.Length; i++)
                    PulaAktywnychPrzedmiotow.Instancja.ZwolnijObiekt( _obiektySkladnikow[i]);
            _obiektySkladnikow = null;
        }
        private void Update()
        {
            _licznikSekund -= Time.deltaTime;
            if (_licznikSekund < 0)
            {
                _licznikSekund = CZESTOTLIWOSCSPRAWDZANODLEGLOSCI;
                if ((MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.position - transform.position).magnitude > MenedzerUI.DYSTANSPOKAZYWANIAKANWY)
                {
                    gameObject.SetActive(false);
                }
            }
        }
    }
}
