﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

namespace ZielarzSilnik
{

    public class KomponentPacjent : MonoBehaviour
    {      
        private const float CZESTOTLIWOSCSPRAWDZANODLEGLOSCI = 0.5f;
        private const int LICZBAIMION = 15;
        private const int LICZBANAZWISK = 20;

        public Pacjent WewnetrznyPacjent { get; private set; }

        public Image WzorzecZielony, WzorzecZolty, WzorzecPomaranczowy, WzorzecCzerwony;
        public Image[] OznaczeniaChorob;
        private Text _infoPacjenta;
        private float _licznikSekund;

        private void Awake()
        {
            WewnetrznyPacjent = null;
            Canvas UIPacjenta = GetComponentInChildren<Canvas>();
            if (UIPacjenta != null)
                _infoPacjenta = UIPacjenta.GetComponentInChildren<Text>();
            
            _licznikSekund = 0;
            foreach (Image obraz in OznaczeniaChorob)
                obraz.gameObject.SetActive(false);
            WzorzecZielony.gameObject.SetActive(false);
            WzorzecZolty.gameObject.SetActive(false);
            WzorzecPomaranczowy.gameObject.SetActive(false);
            WzorzecCzerwony.gameObject.SetActive(false);
        }
        void Update()
        {
            if (WewnetrznyPacjent == null)
                Inicjalizuj(true);
            _licznikSekund -= Time.deltaTime;
            if (_licznikSekund < 0)
            {
                _licznikSekund = CZESTOTLIWOSCSPRAWDZANODLEGLOSCI;
                if ((MenedzerGry.InstancjaMenedzeraGry.KontrolerGracza.transform.position - transform.position).magnitude < MenedzerUI.DYSTANSPOKAZYWANIAKANWY)
                    _infoPacjenta.transform.parent.gameObject.SetActive(true);
                else
                    _infoPacjenta.transform.parent.gameObject.SetActive(false);
            }
        }
        public void Inicjalizuj(bool JestMezczyzna)
        {
            WewnetrznyPacjent = new Pacjent(MenedzerGry.InstancjaMenedzeraGry.WewnetrznyPoziomTrudnosci);
            SystemDniaNocyPogody.Instancja.ZmianaGodziny += UplynelaGodzina;
            WewnetrznyPacjent.ImieNazwisko = TlumaczCiagow.PodajCiag("imie_" + (JestMezczyzna ? "m" : "k")  + Random.Range(1, LICZBAIMION + 1).ToString()) + " " + TlumaczCiagow.PodajCiag("nazwisko_" + Random.Range(1, LICZBANAZWISK + 1).ToString());
            OdswiezInformacje();
        }
        public void WylosujChoroby(bool krytyczne, int poziomTrudnosci)
        {
            WewnetrznyPacjent.WylosujChoroby(krytyczne, poziomTrudnosci);
            gameObject.SetActive(WewnetrznyPacjent.LiczbaAktualnychZdarzen > 0);
            OdswiezInformacje();
        }
        //przekazuje pacjentowi przedmiot, zwraca true jeśli przedmiot został przyjęty lub false jeśli nie
        public bool DodajPrzedmiotLeczacy(Przedmiot nowyPrzedmiot)
        {
            if (nowyPrzedmiot == null || nowyPrzedmiot.WewnetrznyPrzedmiotLeczniczy == null)
                return false;
            WewnetrznyPacjent.DodajPrzedmiotLeczacy(new PrzedmiotLeczniczy(nowyPrzedmiot.WewnetrznyPrzedmiotLeczniczy));
            MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.UstawAtrybut("Zloto", MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PobierzAtrybut("Zloto") + (int)(nowyPrzedmiot.WewnetrzneDane.Wartosc * KonfiguratorGry.RoznicaCenSprzedazy));
            OdswiezInformacje();
            return true;
        }
        private void UplynelaGodzina(int godzina)
        {
            if (WewnetrznyPacjent.JestZywy)
            {
                WewnetrznyPacjent.GodzinowaObslugaZdarzen();
                PacjentPrzezylPowazneZdarzenie();
                if (WewnetrznyPacjent.LicznikOczekiwania == 0)
                {
                    WewnetrznyPacjent.KoniecLeczenia();
                    if(!WewnetrznyPacjent.JestZdrowy)
                        for(int i = 0; i < WewnetrznyPacjent.LiczbaAktualnychZdarzen; i++)
                            MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.UstawAtrybut("Reputacja", MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PobierzAtrybut("Reputacja") * KonfiguratorGry.ReputacjaZaChorobe);
                } 
                OdswiezInformacje();
                if (!WewnetrznyPacjent.JestZywy)
                    PacjentZmarl(WewnetrznyPacjent.LicznikOczekiwania == 0);
                if (WewnetrznyPacjent.JestZdrowy)
                    PacjentWyzdrowial(WewnetrznyPacjent.LicznikOczekiwania == 0);
                if (WewnetrznyPacjent.LicznikOczekiwania == 0 && !WewnetrznyPacjent.JestZdrowy && WewnetrznyPacjent.JestZywy)
                    MenedzerUI.Instancja.PokazMaleInfo(string.Format("{0} {1} {2}", TlumaczCiagow.PodajCiag("Pacjent"), WewnetrznyPacjent.ImieNazwisko, TlumaczCiagow.PodajCiag("PoszedlDoDomu")));
                if (WewnetrznyPacjent.JestZdrowy || !WewnetrznyPacjent.JestZywy || WewnetrznyPacjent.LicznikOczekiwania == 0)
                {
                    SystemDniaNocyPogody.Instancja.ZmianaGodziny -= UplynelaGodzina;
                    Destroy(gameObject);
                }
            }
        }             
        private void PacjentWyzdrowial(bool wDomu)
        {
            WewnetrznyPacjent.PacjentWyzdrowial();
            MenedzerUI.Instancja.PokazMaleInfo(string.Format("{0} {1} {2}", TlumaczCiagow.PodajCiag("Pacjent"), WewnetrznyPacjent.ImieNazwisko, wDomu ? TlumaczCiagow.PodajCiag("PoszedlDoDomuWyzdrowial") : TlumaczCiagow.PodajCiag("Wyzdrowial")));
        }
        private void PacjentZmarl(bool wDomu)
        {
            WewnetrznyPacjent.PacjentZmarl();
            if (!wDomu)
            {
                if (WewnetrznyPacjent.PrzyczynaZgonu != "")
                    MenedzerUI.Instancja.PokazMaleInfo(string.Format("{0} {1} {2} {3}", TlumaczCiagow.PodajCiag("Pacjent"), WewnetrznyPacjent.ImieNazwisko, TlumaczCiagow.PodajCiag("ZmarlGwaltownie"), WewnetrznyPacjent.PrzyczynaZgonu));
                else
                    MenedzerUI.Instancja.PokazMaleInfo(string.Format("{0} {1} {2}", TlumaczCiagow.PodajCiag("Pacjent"), WewnetrznyPacjent.ImieNazwisko, TlumaczCiagow.PodajCiag("Zmarl")));
            }
            else
                MenedzerUI.Instancja.PokazMaleInfo(string.Format("{0} {1} {2}", TlumaczCiagow.PodajCiag("Pacjent"), WewnetrznyPacjent.ImieNazwisko, TlumaczCiagow.PodajCiag("PoszedlDoDomuZmarl")));
        }
        private void PacjentPrzezylPowazneZdarzenie()
        {
            if (WewnetrznyPacjent.WazneZdarzenia.Count > 0)
                foreach(string wazneZdarzenie in WewnetrznyPacjent.WazneZdarzenia)
                    MenedzerUI.Instancja.PokazMaleInfo(TlumaczCiagow.PodajCiag("Pacjent") + " " + WewnetrznyPacjent.ImieNazwisko + " " + wazneZdarzenie + ".");
        }
        private void OdswiezInformacje()
        {
            if (_infoPacjenta != null)
                _infoPacjenta.text = WewnetrznyPacjent.ZrzutZdarzen(MenedzerGry.WERSJADEBUG);
            int uzyteOznaczenia = 0;
            for (int i = 0; uzyteOznaczenia < OznaczeniaChorob.Length && i < WewnetrznyPacjent.LiczbaAktualnychZdarzen; i++)
            {
                Vector2[] punkty = MechanikaCzesciCiala.PodajPunktyNaMapce(WewnetrznyPacjent.PodajZdarzenie(i).Lokalizacja);
                for (int j = 0; j < punkty.Length && uzyteOznaczenia < OznaczeniaChorob.Length; j++)
                {
                    OznaczeniaChorob[uzyteOznaczenia].gameObject.SetActive(true);
                    OznaczeniaChorob[uzyteOznaczenia].gameObject.GetComponent<RectTransform>().anchoredPosition3D = new Vector3(punkty[j].x, punkty[j].y, 0) ;
                    if (WewnetrznyPacjent.PodajZdarzenie(i).StanSilyInt() == 0)
                        OznaczeniaChorob[uzyteOznaczenia].sprite = WzorzecZielony.sprite;
                    else if (WewnetrznyPacjent.PodajZdarzenie(i).StanSilyInt() == 1)
                        OznaczeniaChorob[uzyteOznaczenia].sprite = WzorzecZolty.sprite;
                    else if (WewnetrznyPacjent.PodajZdarzenie(i).StanSilyInt() == 2)
                        OznaczeniaChorob[uzyteOznaczenia].sprite = WzorzecPomaranczowy.sprite;
                    else
                        OznaczeniaChorob[uzyteOznaczenia].sprite = WzorzecCzerwony.sprite;
                    uzyteOznaczenia++;
                }
            }                
            for(; uzyteOznaczenia < OznaczeniaChorob.Length; uzyteOznaczenia++)
            {
                OznaczeniaChorob[uzyteOznaczenia].gameObject.SetActive(false);
            }
        }

    }
}
