﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEngine;
namespace ZielarzSilnik
{
    public class EfektPodnoszenia : MonoBehaviour
    {
        private const float CZASCALKOWITY = 0.75f;
        private readonly Vector3 PRZESUNIECIECALKOWITE = new Vector3(0, 1f, 0);
        private const float OBROTCALKOWITY = 540;
        private Vector3 _pozycjaStartowa, _skalaStartowa;
        private Quaternion _rotacjaStartowa;
        private float _czasUplynal;
       
        void Start()
        {
            _czasUplynal = 0;
            _pozycjaStartowa = transform.localPosition;
            _rotacjaStartowa = transform.localRotation;
            _skalaStartowa = transform.localScale;
        }

        void Update()
        {
            _czasUplynal += Time.deltaTime;
            if (_czasUplynal >= CZASCALKOWITY)
                ZatrzymajEfekt();
            else
            {
                transform.localPosition = Vector3.Lerp(_pozycjaStartowa, _pozycjaStartowa + PRZESUNIECIECALKOWITE, _czasUplynal / CZASCALKOWITY);
                transform.localRotation = _rotacjaStartowa;
                transform.Rotate(transform.up, OBROTCALKOWITY * _czasUplynal / CZASCALKOWITY);
                transform.localScale = Vector3.Lerp(_skalaStartowa, _skalaStartowa * (1 - _czasUplynal / CZASCALKOWITY), _czasUplynal / CZASCALKOWITY);

            }
        }
        private void ZatrzymajEfekt()
        {
            GetComponent<Przedmiot>().FinalizujDodanieDoPlecaka();
        }
    }
}