﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEngine;
using UnityEngine.UI;

namespace ZielarzSilnik
{
    public enum FazaPomocy { FazaPierwsza, FazaDruga, FazaTrzecia, FazaCzwarta, FazaPiata, PomocStala}
    public class UIPomocy : MonoBehaviour
    {
        public Text TekstPomoc;
        public Text TekstInstrukcja;
        private float _licznikCzasu;

        private void Start()
        {
            if (TekstPomoc == null)
                Debug.LogError("Nie ustawiono pola TekstPomoc");
            if (TekstInstrukcja == null)
                Debug.LogError("Nie ustawiono pola TekstInstrukcja");
            gameObject.SetActive(false);
            _licznikCzasu = 0;
        }
        public void Uaktywnij(FazaPomocy ktoraFaza)
        {
            gameObject.SetActive(true);
            switch (ktoraFaza)
            {
                case FazaPomocy.FazaPierwsza:
                    TekstPomoc.text = TlumaczCiagow.PodajCiag("Przewodnik_1");
                    break;
                case FazaPomocy.FazaDruga:
                    TekstPomoc.text = TlumaczCiagow.PodajCiag("Przewodnik_2");
                    break;
                case FazaPomocy.FazaTrzecia:
                    TekstPomoc.text = TlumaczCiagow.PodajCiag("Przewodnik_3");
                    break;
                case FazaPomocy.FazaCzwarta:
                    TekstPomoc.text = TlumaczCiagow.PodajCiag("Przewodnik_4");
                    break;
                case FazaPomocy.FazaPiata:
                    TekstPomoc.text = TlumaczCiagow.PodajCiag("Przewodnik_5");
                    break;
               default:
                    TekstPomoc.text = TlumaczCiagow.PodajCiag("Przewodnik_skrot");
                    break;
            }
            TekstInstrukcja.text = TlumaczCiagow.PodajCiag("Przewodnik_komunikat");
            _licznikCzasu = 2;
        }
        private void Update()
        {
            if (_licznikCzasu > 0)
                _licznikCzasu -= Time.deltaTime;
            if ((Input.anyKeyDown || Input.GetMouseButtonDown(0) || Input.GetMouseButtonDown(1) )&& _licznikCzasu <= 0)
                gameObject.SetActive(false);
        }
    }

}
