﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEngine;
using UnityEngine.UI;

namespace ZielarzSilnik
{

    public class Plecak : MonoBehaviour
    {
        public const int ROZMIARPLECAKA = 5;   //maks. liczba przedmiotów w plecaku
        public const int ROZMIARDUSZKAPLECAKA = 512;  //rozmiar duszka panelu przedmiotu
        public GameObject WzorzecPaneluPlecaka;   //wzorzec do generowania panelów przedmiotów
        public GameObject ZnacznikAktywnejRamki;   //obiekt ktorym bedziemy zaznaczac aktywna ramke
        public Text OpisAktywnegoPrzedmiotu;   // tekst mówiący o tym jak nazywa się aktywnie wybrany przedmiot
        public Canvas KanwaOpisuAktywnegoPrzedmiotu;
        private bool _rozszerzony;

        //informuje i ustawia plecak rozszerzony do wszystkich przedmiotow
        public bool Rozszerzony
        {
            get { return _rozszerzony; }
            set
            {
                if (_rozszerzony)
                    Debug.Log("");
                _rozszerzony = value;
                OdswiezWszystko();
            }
        }
        //przedmiot na pozycji pozycja, null oznacza brak przedmiotu w plecaku na tej pozycji
        public Przedmiot this[int pozycja]
        {
            get
            {
                if (pozycja >= 0 && pozycja < ROZMIARPLECAKA)
                    return _przedmioty[pozycja];
                else
                    return null;
            }
            private set
            {
                _przedmioty[pozycja] = value;
            }
        }
        //przedmiot na aktywnej pozycji pozycja, null oznacza brak przedmiotu na aktywnej pozycji
        public Przedmiot AktywnyPrzedmiot
        {
            get
            {
                return this[_wybranyPanel];
            }
        }

        private Przedmiot[] _przedmioty;
        private GameObject[] _panelePlecaka;
        private int _wybranyPanel;

        public void OdczytajGre()
        {
            for (int i = 0; i < ROZMIARPLECAKA; i++)
            {
                string przedmiotI = MenedzerGry.InstancjaMenedzeraGry.OdczytajZmiennaString("plecak_" + i);
                if (przedmiotI != null && przedmiotI != "")
                {
                    GameObject nowyPrzedmiot = PulaAktywnychPrzedmiotow.Instancja.PodajObiekt(przedmiotI);
                    if (nowyPrzedmiot.GetComponent<Przedmiot>() == null)
                        Debug.LogError("Błędny przedmiot w plecaku: " + przedmiotI);
                    else
                    {
                        nowyPrzedmiot.GetComponent<Przedmiot>().PrzygotujNaPlecak();
                        Dodaj(nowyPrzedmiot.GetComponent<Przedmiot>());
                    }
                }
                else
                    _przedmioty[i] = null;
            }
        }
        public void ZapiszGre()
        {
            for (int i = 0; i < ROZMIARPLECAKA; i++)
            {
                if (_przedmioty[i] != null)
                    MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("plecak_" + i, _przedmioty[i].name);
                else
                    MenedzerGry.InstancjaMenedzeraGry.ZapiszZmienna("plecak_" + i,"");
            }
        }

        //Dodaje przedmiot do plecaka na pierwsze wolne miejsce albo na miejsce _wybranyPanel jesli brak wolnych miejsc
        public void Dodaj(Przedmiot dodawanyPrzedmiot)
        {
            int panelNaKtoryDodajemy = _wybranyPanel;
            if (this[panelNaKtoryDodajemy] != null)
                for (int i = ROZMIARPLECAKA - 1; i >= 0; i--)
                    if (_przedmioty[i] == null)
                        panelNaKtoryDodajemy = i;
            if (this[panelNaKtoryDodajemy] != null)
                PrzedmiotZostalUsuniety(this[panelNaKtoryDodajemy]);
            this[panelNaKtoryDodajemy] = dodawanyPrzedmiot;
            dodawanyPrzedmiot.transform.parent = transform;
            dodawanyPrzedmiot.transform.localScale = dodawanyPrzedmiot.SkalaWPlecaku;
            dodawanyPrzedmiot.transform.localRotation = Quaternion.Euler(dodawanyPrzedmiot.RotacjaWPlecaku);
            OdswiezPozycjePrzedmiotow();
            MenedzerAktywnychPrzedmiotow.Instancja.UsunAktywnyPrzedmiot(dodawanyPrzedmiot.GetComponent<AktywnyObiekt>());
        }
        //przesuwa wybrany panel o przesuniecie (1 w prawo -1 w lewo)
        public void PrzesunWybranyPanel(int przesuniecie)
        {
            _wybranyPanel += przesuniecie;
            if (_wybranyPanel < 0)
                _wybranyPanel = ROZMIARPLECAKA - 1;
            _wybranyPanel %= ROZMIARPLECAKA;
            OdswiezWszystko();
        }
        //usuwa przedmiot z plecaka nie wyrzucajac go na ziemie (zniszczony, przekazany komus itp.)
        public void ZniszczPoCichuPrzedmiot(Przedmiot ktoryPrzedmiot)
        {
            int indeksZnaleziony = -1;
            for (int i = 0; i < ROZMIARPLECAKA; i++)
                if (_przedmioty[i] == ktoryPrzedmiot)
                    indeksZnaleziony = i;
            if (indeksZnaleziony != -1)
            {
                _przedmioty[indeksZnaleziony] = null;
                Destroy(ktoryPrzedmiot.gameObject);
            }
        }
        private void Awake()
        {
            _przedmioty = new Przedmiot[ROZMIARPLECAKA];
            _panelePlecaka = new GameObject[ROZMIARPLECAKA];
            if (ZnacznikAktywnejRamki == null)
                Debug.Log("Nieustaiono znacznika aktywnego panelu");
            if (WzorzecPaneluPlecaka == null)
                Debug.Log("Nieustaiono wzorca panelu plecaka");
            else
                GenerujPaneleUI();
            Rozszerzony = false;
            _wybranyPanel = 0;
            transform.position = Camera.main.ScreenToWorldPoint(new Vector3(5, 5, 0.35f));
        }

        private void GenerujPaneleUI()
        {
            if (_panelePlecaka != null)
                foreach (GameObject panel in _panelePlecaka)
                    Destroy(panel);
            _panelePlecaka = new GameObject[ROZMIARPLECAKA];
            for (int i = 0; i < ROZMIARPLECAKA; i++)
            {
                _panelePlecaka[i] = Instantiate(WzorzecPaneluPlecaka, transform);
                _panelePlecaka[i].transform.localPosition = new Vector3(0f, 0f, 0f);
                _panelePlecaka[i].transform.localRotation = Quaternion.identity;
                _panelePlecaka[i].SetActive(true);
            }
            WzorzecPaneluPlecaka.SetActive(false);
        }
        private void OdswiezWszystko()
        {
            OdswiezPozycjePaneliUI();
            OdswiezPozycjePrzedmiotow();
            OdswiezInformacjeOAktywnymPrzedmiocie();
        }
        private void OdswiezPozycjePaneliUI()
        {
            if (_panelePlecaka == null)
                GenerujPaneleUI();
            float rozmiarPanelu = (ROZMIARDUSZKAPLECAKA / 128f) * WzorzecPaneluPlecaka.transform.localScale.x;
            for (int i = 0; i < ROZMIARPLECAKA; i++)
            {
                _panelePlecaka[i].SetActive(Rozszerzony | i == _wybranyPanel);
                if (Rozszerzony)
                    _panelePlecaka[i].transform.localPosition = new Vector3(rozmiarPanelu * 0.5f + i * (rozmiarPanelu + 0.01f), rozmiarPanelu * 0.5f, 0);
                else
                    _panelePlecaka[i].transform.localPosition = new Vector3(rozmiarPanelu * 0.5f, rozmiarPanelu * 0.5f, 0);
            }
            ZnacznikAktywnejRamki.SetActive(Rozszerzony);
            ZnacznikAktywnejRamki.transform.localPosition = _panelePlecaka[_wybranyPanel].transform.localPosition;
            KanwaOpisuAktywnegoPrzedmiotu.transform.localPosition = new Vector3(_panelePlecaka[ROZMIARPLECAKA - 1].transform.localPosition.x + rozmiarPanelu + 0.01f, rozmiarPanelu * 0.5f, 0); 
        }

        private void OdswiezPozycjePrzedmiotow()
        {
            for (int i = 0; i < ROZMIARPLECAKA; i++)
            {
                if (this[i] != null)
                {
                    this[i].gameObject.SetActive(_panelePlecaka[i].activeInHierarchy);
                    this[i].transform.localPosition = _panelePlecaka[i].transform.localPosition + this[i].PrzesuniecieWPlecaku;
                }
            }
        }
        private void OdswiezInformacjeOAktywnymPrzedmiocie()
        {
            if(Rozszerzony && this[_wybranyPanel] != null)
            {
                OpisAktywnegoPrzedmiotu.text = this[_wybranyPanel].Nazwa;              
                OpisAktywnegoPrzedmiotu.gameObject.SetActive(true);                
            } else
            {
                OpisAktywnegoPrzedmiotu.gameObject.SetActive(false);
                
            }
        }
        private void PrzedmiotZostalUsuniety(Przedmiot usuniety)
        {
            usuniety.UsunZPlecaka();
            MenedzerAktywnychPrzedmiotow.Instancja.DodajAktywnyPrzedmiot(usuniety.GetComponent<AktywnyObiekt>());
        }
    }
}
