﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using System;
using UnityEngine;
namespace ZielarzSilnik
{
    //obsluga zdarzen zmiany czasu, zapisujac sie z zewnatrz do SystemDniaNocyPogody.ZmianaMinuty i SystemDniaNocyPogody.ZmianaGodziny dowolny sluchacz moze byc informowany o zmianie wartosci czasu gry
    public delegate void DelegatZmianaCzasu(int obecnaWartosc);

    public class SystemDniaNocyPogody : MonoBehaviour
    {
        public static SystemDniaNocyPogody Instancja { get; private set; }
        public Light Slonce;
        public int DlugoscDnia = 6;                   // dlugosc 12-godzin dnia podana w minutach
        public int DlugoscNocy = 6;                   // dlugosc 12-godzin nocy podana w minutach
        public float WirtualnaGodzina = 12;          //aktualna godzina w swiecie gry, 0 oznacza polnoc, kazde 1 kolejna godzine (np. 12 oznacza 12 rano). Noc zawiera sie miedzy 19 a 7 rano

        private float _licznikSekund;
        private const float _interwalObliczen = 0.05f;   //jak czesto czynimy obliczenia (w sekundach)

        public bool JestDzien { get { return WirtualnaGodzina >= 7 && WirtualnaGodzina < 19; } }
        public int Godzina { get { return (int)WirtualnaGodzina; } }
        public int Minuta { get { return (int)((WirtualnaGodzina - Godzina) * 60); } }

        public event DelegatZmianaCzasu ZmianaMinuty;
        public event DelegatZmianaCzasu ZmianaGodziny;

        private void Awake()
        {
            if (Instancja != null && Instancja != this)
                throw new Exception("Niedozwolone tworzenie kolejnej kopii klasy SystemDniaNocyPogody");
            Instancja = this;
        }
        void Start()
        {            
            if (Slonce == null)
                Debug.LogError("Pole Slonce w komponencie SystemDniaNocyPogody jest równe null.");
            _licznikSekund = 0;
        }

        void Update()
        {
            _licznikSekund -= Time.deltaTime;
            if (_licznikSekund < 0)
            {
                _licznikSekund = _interwalObliczen;
                UplywCzasu();
            }
        }

        private void UplywCzasu()
        {
            int oldGodzina = Godzina;
            int oldMinuta = Minuta;
            //oblicz nowy czas dnia
            if (JestDzien)
                WirtualnaGodzina += 1f / (DlugoscDnia * 60 / (_interwalObliczen * 12));
            else
                WirtualnaGodzina += 1f / (DlugoscNocy * 60 / (_interwalObliczen * 12));
            if (WirtualnaGodzina >= 24)
                WirtualnaGodzina -= 24;
            if (oldMinuta != Minuta)
                UplynelaMinuta();
            if (oldGodzina != Godzina)
                UplynelaGodzina();
            //ustaw odpowiednio Slonce
            float czescDnia = (WirtualnaGodzina - 7) / 24;
            float katSlonca = czescDnia * 360;
            Vector3 punktPosredni = new Vector3(0, 0, 0);
            Slonce.transform.position = punktPosredni + Quaternion.Euler(0, 0, katSlonca) * (10 * Vector3.right);
            Slonce.transform.LookAt(punktPosredni);
        }

        private void UplynelaMinuta()
        {
            ZmianaMinuty?.Invoke(Minuta);
        }

        private void UplynelaGodzina()
        {
            ZmianaGodziny?.Invoke(Godzina);
        }
    }
}