﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using SymulatorZielarza_WarstwaBazowa;
using System;
using UnityEngine;

namespace ZielarzSilnik
{
    public class MenedzerGry: MonoBehaviour
    {
        public const bool WERSJADEBUG = false;
        public const bool WERSJASTEAM = true;
        public const uint STEAMID = 1208090;
        public static MenedzerGry InstancjaMenedzeraGry { get; private set; }
        public Gracz ObiektGracza { get; private set; }
        public int WewnetrznyPoziomTrudnosci { get; private set; }
        public MenedzerPoziomuTrudnosci.PoziomTrudnosci GlownyPoziomTrudnosci { get; private set; }
        public SelektorPlatformy ObiektSelektoraPlatformy { get; private set; }
        public GameObject[] PunktyPacjentowStacjonarnych,  PunktyPacjentowLezacych;
        public GameObject KontrolerGracza;
        public Plecak ObiektPlecaka;
        public float MAXXBRZEGU = 470;
        public float MAXZBRZEGU = 470;
        public float MINXBRZEGU = -230;
        public float MINZBRZEGU = -230;
        public const float CZESTOSCBADANIA = 4;

        private bool _PierwszyUpdate;
        private GameObject _SzablonPacjentaStojacegoM, _SzablonPacjentaLezacegoM;
        private GameObject _SzablonPacjentaStojacegoK, _SzablonPacjentaLezacegoK;
        private IStanGry _menedzerZapisu;
        private float _licznikCzasu;
        private Vector3 _ostatniaBezpiecznaPozycja;
        private Terrain _teren;
        public void ZapiszGre()
        {
            _menedzerZapisu.ZapiszKlucz("pozycja_gracza_x", KontrolerGracza.GetComponent<BazowyKontrolerGracza>().PodajPozycjeGracza().x);
            _menedzerZapisu.ZapiszKlucz("pozycja_gracza_y", KontrolerGracza.GetComponent<BazowyKontrolerGracza>().PodajPozycjeGracza().y);
            _menedzerZapisu.ZapiszKlucz("pozycja_gracza_z", KontrolerGracza.GetComponent<BazowyKontrolerGracza>().PodajPozycjeGracza().z);
            _menedzerZapisu.ZapiszKlucz("wewnetrznyPoziomTrudnosci", WewnetrznyPoziomTrudnosci);

            ObiektGracza.ZapiszGre();
            ObiektPlecaka.ZapiszGre();
            MenedzerAktywnychPrzedmiotow.Instancja.ZapiszGre();
            SystemDniaNocyPogody.Instancja.ZapiszGre();
            _menedzerZapisu.ZapiszGre();
  
        }
        public void OdczytajGre()
        {
            UnityEngine.Random.InitState(DateTime.Now.Millisecond);
            GeneratorObiektow.ZiarnoLosowosci = UnityEngine.Random.Range(int.MinValue, int.MaxValue);
            _menedzerZapisu.ZaladujGre();
            if (_menedzerZapisu.istniejeKlucz("poziomTrudnosci"))
                MenedzerPoziomuTrudnosci.KonfigurujPoziomTrudnosci((MenedzerPoziomuTrudnosci.PoziomTrudnosci)_menedzerZapisu.PobierzKluczInt("poziomTrudnosci"));
            else
                MenedzerPoziomuTrudnosci.KonfigurujPoziomTrudnosci(MenedzerPoziomuTrudnosci.DomyslnyPoziomTrudnosci);
            SystemDniaNocyPogody.Instancja.OdczytajGre();
            MenedzerAktywnychPrzedmiotow.Instancja.OdczytajGre();
            ObiektPlecaka.OdczytajGre();
            ObiektGracza = new Gracz();
            ObiektGracza.OdczytajGre();
            if (_menedzerZapisu.istniejeKlucz("pozycja_gracza_x"))
                KontrolerGracza.GetComponent<BazowyKontrolerGracza>().PrzesunGracza(_teren, new Vector3(
                    _menedzerZapisu.PobierzKluczFloat("pozycja_gracza_x"), _menedzerZapisu.PobierzKluczFloat("pozycja_gracza_y"), _menedzerZapisu.PobierzKluczFloat("pozycja_gracza_z")));
            if (_menedzerZapisu.istniejeKlucz("wewnetrznyPoziomTrudnosci"))
                WewnetrznyPoziomTrudnosci = _menedzerZapisu.PobierzKluczInt("wewnetrznyPoziomTrudnosci");
            else
                WewnetrznyPoziomTrudnosci = 1;
            MenedzerUI.Instancja.PoOdczytaniuGry();
        }
        public void ZapiszZmienna(string zmienna, object wartosc)
        {
            _menedzerZapisu.ZapiszKlucz(zmienna, wartosc);
        }
        public int OdczytajZmiennaInt(string zmienna)
        {
            return _menedzerZapisu.PobierzKluczInt(zmienna);
        }
        public float OdczytajZmiennaFloat(string zmienna)
        {
            return _menedzerZapisu.PobierzKluczFloat(zmienna);
        }
        public string OdczytajZmiennaString(string zmienna)
        {
            return _menedzerZapisu.PobierzKluczString(zmienna);
        }
        public bool istniejeKlucz(string zmienna)
        {
            return _menedzerZapisu.istniejeKlucz(zmienna);
        }
        public void KoniecGry(string przyczyna)
        {
            ZapiszZmienna("przegrana", przyczyna);
            ZapiszGre();
            UnityEngine.SceneManagement.SceneManager.LoadScene("Startowa");
        }       

        private void Awake()
        {
            if (InstancjaMenedzeraGry != null && InstancjaMenedzeraGry != this)
                throw new Exception("Niedozwolone tworzenie kolejnej kopii klasy MenedzerGry");
            InstancjaMenedzeraGry = this;
#if UNITY_STANDALONE
                if (WERSJASTEAM)
                {
                FasadaSteam.SteamZainicjalizowany = false;
                    try
                    {
                    FasadaSteam.SteamZainicjalizowany = FasadaSteam.SteamAPI_Init();
                        if (!FasadaSteam.SteamZainicjalizowany)
                            Debug.LogError("Inicjalizacja Steama niepowiodła się!");
                    FasadaSteam.SteamAPI_RestartAppIfNecessary(STEAMID);
                    }
                    catch (System.Exception)
                    {
                    FasadaSteam.SteamZainicjalizowany = false;
                    }
                }
#endif
            ObiektSelektoraPlatformy = GetComponent<SelektorPlatformy>();
            if (ObiektSelektoraPlatformy == null)
                Debug.LogError("Brak selektora platformy!");
            IKonfiguratorSceny konfigurator = ObiektSelektoraPlatformy.UtworzKonfiguratorSceny();
            konfigurator.UtworzObiektySceny(gameObject);
            _PierwszyUpdate = true;
            _SzablonPacjentaLezacegoM = null;
            _SzablonPacjentaStojacegoM = null;
            _SzablonPacjentaLezacegoK = null;
            _SzablonPacjentaStojacegoK = null;
            _menedzerZapisu = ObiektSelektoraPlatformy.UtworzMenedzerStanuGry();
            MenedzerZielarstwa.Instancja.ZaladujDane();
            _licznikCzasu = CZESTOSCBADANIA;
            _teren = transform.GetComponentInChildren<Terrain>();
        }
        private void Start()
        {
            OdczytajGre();
        }

        private void Update()
        {
            if (_PierwszyUpdate)
            {
                ObiektGracza.Inicjuj();
                SystemDniaNocyPogody.Instancja.ZmianaGodziny += UplynelaGodzina;
                _PierwszyUpdate = false;
            }
            _licznikCzasu -= Time.deltaTime;
            if (_licznikCzasu <= 0)
            {
                _licznikCzasu = CZESTOSCBADANIA;
                ZbadajBrzegMapy();
            }           
        }
        private void ZbadajBrzegMapy()
        {
            if (KontrolerGracza.transform.position.x < MINXBRZEGU || KontrolerGracza.transform.position.x > MAXXBRZEGU || KontrolerGracza.transform.position.z < MINZBRZEGU || KontrolerGracza.transform.position.z > MAXZBRZEGU)
            {
                KontrolerGracza.GetComponent<BazowyKontrolerGracza>().PrzesunGracza(_teren, _ostatniaBezpiecznaPozycja);
                MenedzerUI.Instancja.PokazMaleInfo(TlumaczCiagow.PodajCiag("InfoBrzegowe"));
            }
            else
                _ostatniaBezpiecznaPozycja = KontrolerGracza.transform.position;
        }

        private void OnApplicationQuit()
        {
            ZapiszGre();
#if UNITY_STANDALONE
            if (WERSJASTEAM)
            {
                FasadaSteam.SteamAPI_Shutdown();
            }
#endif
        }

        private void UplynelaGodzina(int godzina)
        {
            float reputacja = MenedzerGry.InstancjaMenedzeraGry.ObiektGracza.PobierzAtrybut("Reputacja");
            int rorzutLosowosci = 1;
            if (reputacja < 0.25)
                rorzutLosowosci = 8;
            else if (reputacja < 0.5)
                rorzutLosowosci = 6;
            else if (reputacja < 0.75)
                rorzutLosowosci = 4;
            else if (reputacja < 1)
                rorzutLosowosci = 3;
            else if (reputacja < 1.33)
                rorzutLosowosci = 2;
            foreach (GameObject punktpacjenta in PunktyPacjentowStacjonarnych)
                if (punktpacjenta.transform.childCount == 0 && UnityEngine.Random.Range(0, rorzutLosowosci) == 0)
                    UtworzPacjenta(punktpacjenta, false);
            foreach (GameObject punktpacjenta in PunktyPacjentowLezacych)
                if (punktpacjenta.transform.childCount == 0 && UnityEngine.Random.Range(0, rorzutLosowosci) == 0)
                    UtworzPacjenta(punktpacjenta, true);
            if (OdczytajZmiennaInt("przewodnik") == 0)
            {
                MenedzerUI.Instancja.KanwaPomocy.GetComponent<UIPomocy>().Uaktywnij(FazaPomocy.FazaPierwsza);
                ZapiszZmienna("przewodnik", 2);
            }               
            if (godzina == 23 && WewnetrznyPoziomTrudnosci < KonfiguratorGry.MaksymalnyWewnetrznyPoziomTrudnosci)
                WewnetrznyPoziomTrudnosci++;
        }

        private void UtworzPacjenta(GameObject punktTworzenia, bool lezacy)
        {
            if (_SzablonPacjentaStojacegoM == null)
                _SzablonPacjentaStojacegoM = Resources.Load<GameObject>("Prefaby/PacjentM");
            if (_SzablonPacjentaLezacegoM == null)
                _SzablonPacjentaLezacegoM = Resources.Load<GameObject>("Prefaby/PacjentLezacyM");
            if (_SzablonPacjentaStojacegoK == null)
                _SzablonPacjentaStojacegoK = Resources.Load<GameObject>("Prefaby/PacjentK");
            if (_SzablonPacjentaLezacegoK == null)
                _SzablonPacjentaLezacegoK= Resources.Load<GameObject>("Prefaby/PacjentLezacyK");

            if (_SzablonPacjentaStojacegoM == null || _SzablonPacjentaLezacegoM == null || _SzablonPacjentaStojacegoK == null || _SzablonPacjentaLezacegoK == null)
                Debug.LogError("Nie udało się załadować szablonu pacjenta z zasobów.");
            else
            {
                bool mezczyzna = UnityEngine.Random.Range(0, 2) == 0;
                GameObject szablon;
                if (mezczyzna)
                    szablon = lezacy ? _SzablonPacjentaLezacegoM : _SzablonPacjentaStojacegoM;
                else
                    szablon = lezacy ? _SzablonPacjentaLezacegoK : _SzablonPacjentaStojacegoK;
                GameObject nowyPacjent = Instantiate(szablon, punktTworzenia.transform);
                nowyPacjent.transform.localPosition = Vector3.zero;
                nowyPacjent.transform.localRotation = Quaternion.identity;
                nowyPacjent.GetComponent<KomponentPacjent>().Inicjalizuj(mezczyzna);
                nowyPacjent.GetComponent<KomponentPacjent>().WylosujChoroby(lezacy, WewnetrznyPoziomTrudnosci);
                MenedzerUI.Instancja.PokazMaleInfo(TlumaczCiagow.PodajCiag(lezacy ? "NowyPacjentLezy" : "NowyPacjentStoi") + nowyPacjent.GetComponent<KomponentPacjent>().WewnetrznyPacjent.ImieNazwisko);
            }
        }
    }
}