﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System.Collections.Generic;
using System.Xml.Linq;
using UnityEngine;

namespace ZielarzSilnik
{
    //ogolna struktura informacyjna przedmiotow
    public class DanePrzedmiotu
    {
        public string Nazwa;                        // nazwa przedmiotu(identyfikator ciagu nazwy)
        public string Opis;                         // nieobowiazkowy opis (identyfikator ciągu nazwy)
        public int Wartosc;                         // wartosc zakupu u handlarza [złoto]       
        
        //zaladuj dane przedmiotu z pojedynczego wezla XML 
        public void ZaladujDane(XElement elementXMLDanych)
        {
            if (elementXMLDanych.Attribute("nazwa") == null)
                Debug.LogError("Brak atrybutu nazwa w elemencie danych " + elementXMLDanych.ToString());
            else
                Nazwa = elementXMLDanych.Attribute("nazwa").Value;
            if (elementXMLDanych.Attribute("opis") != null)
                Opis = elementXMLDanych.Attribute("opis").Value;
            else
                Opis = "";
            if (elementXMLDanych.Attribute("wartosc") != null)
                Wartosc = int.Parse(elementXMLDanych.Attribute("wartosc").Value);
            else
                Wartosc = 1;            
         }
    }
}
