﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author

using UnityEngine;
using UnityEngine.UI;

namespace ZielarzSilnik
{
    public class ScenaStartowa : MonoBehaviour
    {
        public Text TekstNowy, TekstKontynuuj, TekstZamknij;
        public Text TekstPrzegrana;

        private void Start()
        {
            if (TekstNowy == null)
                Debug.LogError("Nie ustawiono pola TekstNowy");
            if (TekstKontynuuj == null)
                Debug.LogError("Nie ustawiono pola TekstKontynuuj");
            if (TekstPrzegrana == null)
                Debug.LogError("Nie ustawiono pola TekstPrzegrana");
            if (TekstZamknij == null)
                Debug.LogError("Nie ustawiono pola TekstZamknij");
            TekstNowy.text = TlumaczCiagow.PodajCiag("nowy");
            TekstKontynuuj.text = TlumaczCiagow.PodajCiag("kontynuuj");
            TekstZamknij.text = TlumaczCiagow.PodajCiag("zamknij");
            SprawdzPrzegrana();
            SprawdzKontynuacje();
        }

        private void Update()
        {
            if (Input.GetKeyDown(KeyCode.F1))
                KontyuujGre();
            if (Input.GetKeyDown(KeyCode.F5))
                NowaGra();
        }

        public void NowaGra()
        {
            StanGry.IStanGry menedzerZapisu = StanGry.FabrykaMenedzeraStanuGry.InstancjaMenedzera();
            menedzerZapisu.WyczyscKlucze();
            menedzerZapisu.ZapiszGre();
            KontyuujGre();
        }
        public void KontyuujGre()
        {
            UnityEngine.SceneManagement.SceneManager.LoadScene("ScenaGlowna");
        }
        public void Zamknij()
        {
            Application.Quit();
        }

        private void SprawdzPrzegrana()
        {
            StanGry.IStanGry menedzerZapisu = StanGry.FabrykaMenedzeraStanuGry.InstancjaMenedzera();
            menedzerZapisu.ZaladujGre();
            string powodPrzegranej = menedzerZapisu.PobierzKluczString("przegrana");
            if (powodPrzegranej != "")
            {
                TekstPrzegrana.gameObject.SetActive(true);
                TekstPrzegrana.text = TlumaczCiagow.PodajCiag(powodPrzegranej);
                menedzerZapisu.WyczyscKlucze();
                menedzerZapisu.ZapiszGre();
            }
            else
                TekstPrzegrana.gameObject.SetActive(false);
        }

        private void SprawdzKontynuacje()
        {
            StanGry.IStanGry menedzerZapisu = StanGry.FabrykaMenedzeraStanuGry.InstancjaMenedzera();
            menedzerZapisu.ZaladujGre();
            if(menedzerZapisu.istniejeKlucz("pozycja_gracza_x"))
                TekstKontynuuj.gameObject.SetActive(true);
            else
                TekstKontynuuj.gameObject.SetActive(false);
        
        }
    }

}
