﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System.Collections.Generic;

namespace ZielarzSilnik
{

    public class  Postac
    {
        protected Dictionary<string, float> _atrybutyPostaci;

        public Postac()
        {
            _atrybutyPostaci = new Dictionary<string, float>();
        }

        public float PobierzAtrybut(string nazwa)
        {
            if (_atrybutyPostaci.ContainsKey(nazwa))
                return _atrybutyPostaci[nazwa];
            return 0;
        }

        public void UstawAtrybut(string nazwa, float wartosc)
        {
            if (_atrybutyPostaci.ContainsKey(nazwa))
                _atrybutyPostaci[nazwa] = wartosc;
            else
                _atrybutyPostaci.Add(nazwa, wartosc);
        }
        public void SkasujAtrybut(string nazwa)
        {
            if (_atrybutyPostaci.ContainsKey(nazwa))
                _atrybutyPostaci.Remove(nazwa);
        }

    }
}
