﻿// **** Autor: Jacek Ross - games@ejr.com.pl
// **** Plik jest czescia projektu SymulatorZielarza stworzonego na potrzeby ksiazki "Unity i C#. Praktyka programowania gier" wyd. Helion 2020 oraz czescia kodu gry SymulatorZielarza wydanej w serwisie Steam, wiecej info: http://ejr.com.pl
// **** Dozwolone użycie pod licencją CC0 1.0 (public domain). 
// **** Jeżeli modyfikujesz niniejszy plik - umiesc w nim informacje o tym, ze zawartosc odbiega od oryginalu albo usun informacje o autorze

// **** Author: Jacek Ross - games@ejr.com.pl
// **** This file is a part of SymulatorZielarza project created for book "Unity i C#. Praktyka programowania gier" published by Helion 2020 and a part of source of game SymulatorZielarza published on Steam, more info: http://ejr.com.pl
// **** Usage permission under CC0 1.0 license (public domain). 
// **** If you modified this file - put here an information about that the content of file is modified and diffrent than the original, or delete info about original author


using System.IO;
using System;
using System.Text;
using UnityEngine;
using System.Xml.Linq;
using System.Collections.Generic;

namespace Dodatki
{
    public class Funkcje
    {
        //odczytujemy zasob xml z pliku tekstowego badz AssetBundle
        private static string ZaladujZasobXML(string nazwaPliku, AssetBundle aBDoZaladowania = null)
        {
            StringBuilder zawartosc = new StringBuilder();
            try
            {                
                TextAsset zasobXML;
                if (aBDoZaladowania == null)
                    zasobXML = Resources.Load(nazwaPliku) as TextAsset;
                else
                    zasobXML = aBDoZaladowania.LoadAsset<TextAsset>(nazwaPliku);
                if (zasobXML == null)
                    return "";
                StringReader reader = new StringReader(zasobXML.text);
                zawartosc.Append(reader.ReadToEnd());
                reader.Close();
            }
            catch (Exception)
            {
                Debug.Log("Błąd ładowania " + nazwaPliku);
            }
            return zawartosc.ToString();

        }
        //odczytujemy zasob xml z pliku tekstowego badz AssetBundle i zwracamy go jako XDocument
        public static XDocument ZaladujZasobXMLJakoDoc(string nazwaPliku, AssetBundle aBDoZaladowania = null)
        {
            string zawartosc = ZaladujZasobXML(nazwaPliku, aBDoZaladowania);
            XDocument doc = XDocument.Parse(zawartosc);
            return doc;
        }
        //odczytujemy zasob xml z pliku tekstowego badz AssetBundle i zwracamy go jako liste podelementow glownego wezla o nazwie glownyWezel (jesli takiego nie ma - zostanie zgloszony blad i zwrocony null)
        public static IEnumerable<XElement> ZaladujZasobXMLJakoListeElementow(string nazwaPliku, string glownyWezel, AssetBundle aBDoZaladowania = null)
        {
            XDocument dokument = ZaladujZasobXMLJakoDoc(nazwaPliku, aBDoZaladowania);
            if (dokument.Elements(glownyWezel) == null)
            {
                Debug.LogError("Błąd w pliku " + nazwaPliku);
                return null;
            }
            else
            {
                return dokument.Elements(glownyWezel).Elements();
            }
        }

    }
}