import * as data from './data';
import regression from 'regression';

console.log("Wykonuję regresję liniową:");
console.log("=============================");
const linearModel = regression.linear(data.linear);
console.log("Nachylenie i przesunięcie:");
console.log(linearModel.equation);
console.log("Równanie linii prostej:");
console.log(linearModel.string);
console.log("Miara R^2: " + linearModel.r2);
console.log("Wartość przewidywana dla X = 75: " + linearModel.predict(75)[1]);

console.log("Wykonuję regresję wykładniczą:");
console.log("=============================");
const expModel = regression.exponential(data.exponential);
console.log("Początkowa wartość i tempo:");
console.log(expModel.equation);
console.log("Wzór wykładniczy:");
console.log(expModel.string);
console.log("Miara R^2: " + expModel.r2);
console.log("Wartość przewidywana dla X = -1: " + expModel.predict(-1)[1]);


console.log("Wykonuję regresję wielomianową:");
console.log("=============================");
const polyModel = regression.polynomial(data.polynomial, {order: 4});
console.log("Parametry wielomianu");
console.log(polyModel.equation);
console.log("Wzór wielomianu:");
console.log(polyModel.string);
console.log("Miara R^2: " + polyModel.r2);
console.log("Wartość przewidywana dla X = 6: " + polyModel.predict(6)[1]);
